/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.WatcherInner;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Watcher {
    public String id();

    public String name();

    public String type();

    public String etag();

    public Map<String, String> tags();

    public String location();

    public Long executionFrequencyInSeconds();

    public String scriptName();

    public Map<String, String> scriptParameters();

    public String scriptRunOn();

    public String status();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String lastModifiedBy();

    public String description();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public WatcherInner innerModel();

    public Update update();

    public Watcher refresh();

    public Watcher refresh(Context var1);

    public Response<Void> startWithResponse(Context var1);

    public void start();

    public Response<Void> stopWithResponse(Context var1);

    public void stop();

    public static interface UpdateStages {

        public static interface WithExecutionFrequencyInSeconds {
            public Update withExecutionFrequencyInSeconds(Long var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithExecutionFrequencyInSeconds {
        public Watcher apply();

        public Watcher apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithScriptRunOn {
            public WithCreate withScriptRunOn(String var1);
        }

        public static interface WithScriptParameters {
            public WithCreate withScriptParameters(Map<String, String> var1);
        }

        public static interface WithScriptName {
            public WithCreate withScriptName(String var1);
        }

        public static interface WithExecutionFrequencyInSeconds {
            public WithCreate withExecutionFrequencyInSeconds(Long var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithEtag,
        WithExecutionFrequencyInSeconds,
        WithScriptName,
        WithScriptParameters,
        WithScriptRunOn,
        WithDescription {
            public Watcher create();

            public Watcher create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

