/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.WatcherUpdateProperties;
import java.io.IOException;

public final class WatcherUpdateParameters
implements JsonSerializable<WatcherUpdateParameters> {
    private WatcherUpdateProperties innerProperties;
    private String name;

    private WatcherUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public WatcherUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public Long executionFrequencyInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().executionFrequencyInSeconds();
    }

    public WatcherUpdateParameters withExecutionFrequencyInSeconds(Long executionFrequencyInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WatcherUpdateProperties();
        }
        this.innerProperties().withExecutionFrequencyInSeconds(executionFrequencyInSeconds);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static WatcherUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WatcherUpdateParameters)jsonReader.readObject(reader -> {
            WatcherUpdateParameters deserializedWatcherUpdateParameters = new WatcherUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedWatcherUpdateParameters.innerProperties = WatcherUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWatcherUpdateParameters.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWatcherUpdateParameters;
        });
    }
}

