/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.WebhookInner;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Webhook {
    public String id();

    public String name();

    public String type();

    public Boolean isEnabled();

    public String uri();

    public OffsetDateTime expiryTime();

    public OffsetDateTime lastInvokedTime();

    public Map<String, String> parameters();

    public RunbookAssociationProperty runbook();

    public String runOn();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String lastModifiedBy();

    public String description();

    public String resourceGroupName();

    public WebhookInner innerModel();

    public Update update();

    public Webhook refresh();

    public Webhook refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithParameters {
            public Update withParameters(Map<String, String> var1);
        }

        public static interface WithRunOn {
            public Update withRunOn(String var1);
        }

        public static interface WithIsEnabled {
            public Update withIsEnabled(Boolean var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithIsEnabled,
    UpdateStages.WithRunOn,
    UpdateStages.WithParameters,
    UpdateStages.WithDescription {
        public Webhook apply();

        public Webhook apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithRunOn {
            public WithCreate withRunOn(String var1);
        }

        public static interface WithRunbook {
            public WithCreate withRunbook(RunbookAssociationProperty var1);
        }

        public static interface WithParameters {
            public WithCreate withParameters(Map<String, String> var1);
        }

        public static interface WithExpiryTime {
            public WithCreate withExpiryTime(OffsetDateTime var1);
        }

        public static interface WithUri {
            public WithCreate withUri(String var1);
        }

        public static interface WithIsEnabled {
            public WithCreate withIsEnabled(Boolean var1);
        }

        public static interface WithCreate
        extends WithIsEnabled,
        WithUri,
        WithExpiryTime,
        WithParameters,
        WithRunbook,
        WithRunOn {
            public Webhook create();

            public Webhook create(Context var1);
        }

        public static interface WithName {
            public WithCreate withName(String var1);
        }

        public static interface WithParentResource {
            public WithName withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithName,
    DefinitionStages.WithCreate {
    }
}

