/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.WebhookCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WebhookCreateOrUpdateParameters
implements JsonSerializable<WebhookCreateOrUpdateParameters> {
    private String name;
    private WebhookCreateOrUpdateProperties innerProperties = new WebhookCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(WebhookCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public WebhookCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private WebhookCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    public WebhookCreateOrUpdateParameters withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookCreateOrUpdateProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public String uri() {
        return this.innerProperties() == null ? null : this.innerProperties().uri();
    }

    public WebhookCreateOrUpdateParameters withUri(String uri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookCreateOrUpdateProperties();
        }
        this.innerProperties().withUri(uri);
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTime();
    }

    public WebhookCreateOrUpdateParameters withExpiryTime(OffsetDateTime expiryTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookCreateOrUpdateProperties();
        }
        this.innerProperties().withExpiryTime(expiryTime);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public WebhookCreateOrUpdateParameters withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookCreateOrUpdateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public WebhookCreateOrUpdateParameters withRunbook(RunbookAssociationProperty runbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookCreateOrUpdateProperties();
        }
        this.innerProperties().withRunbook(runbook);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public WebhookCreateOrUpdateParameters withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookCreateOrUpdateProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model WebhookCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model WebhookCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebhookCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            WebhookCreateOrUpdateParameters deserializedWebhookCreateOrUpdateParameters = new WebhookCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateParameters.innerProperties = WebhookCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookCreateOrUpdateParameters;
        });
    }
}

