/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.WebhookUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class WebhookUpdateParameters
implements JsonSerializable<WebhookUpdateParameters> {
    private String name;
    private WebhookUpdateProperties innerProperties;

    public String name() {
        return this.name;
    }

    public WebhookUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private WebhookUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    public WebhookUpdateParameters withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookUpdateProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public WebhookUpdateParameters withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookUpdateProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public WebhookUpdateParameters withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookUpdateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public WebhookUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebhookUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookUpdateParameters)jsonReader.readObject(reader -> {
            WebhookUpdateParameters deserializedWebhookUpdateParameters = new WebhookUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebhookUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebhookUpdateParameters.innerProperties = WebhookUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookUpdateParameters;
        });
    }
}

