/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.WindowsUpdateClasses;
import java.io.IOException;
import java.util.List;

public final class WindowsProperties
implements JsonSerializable<WindowsProperties> {
    private WindowsUpdateClasses includedUpdateClassifications;
    private List<String> excludedKbNumbers;
    private List<String> includedKbNumbers;
    private String rebootSetting;

    public WindowsUpdateClasses includedUpdateClassifications() {
        return this.includedUpdateClassifications;
    }

    public WindowsProperties withIncludedUpdateClassifications(WindowsUpdateClasses includedUpdateClassifications) {
        this.includedUpdateClassifications = includedUpdateClassifications;
        return this;
    }

    public List<String> excludedKbNumbers() {
        return this.excludedKbNumbers;
    }

    public WindowsProperties withExcludedKbNumbers(List<String> excludedKbNumbers) {
        this.excludedKbNumbers = excludedKbNumbers;
        return this;
    }

    public List<String> includedKbNumbers() {
        return this.includedKbNumbers;
    }

    public WindowsProperties withIncludedKbNumbers(List<String> includedKbNumbers) {
        this.includedKbNumbers = includedKbNumbers;
        return this;
    }

    public String rebootSetting() {
        return this.rebootSetting;
    }

    public WindowsProperties withRebootSetting(String rebootSetting) {
        this.rebootSetting = rebootSetting;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("includedUpdateClassifications", this.includedUpdateClassifications == null ? null : this.includedUpdateClassifications.toString());
        jsonWriter.writeArrayField("excludedKbNumbers", this.excludedKbNumbers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("includedKbNumbers", this.includedKbNumbers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("rebootSetting", this.rebootSetting);
        return jsonWriter.writeEndObject();
    }

    public static WindowsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WindowsProperties)jsonReader.readObject(reader -> {
            WindowsProperties deserializedWindowsProperties = new WindowsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("includedUpdateClassifications".equals(fieldName)) {
                    deserializedWindowsProperties.includedUpdateClassifications = WindowsUpdateClasses.fromString(reader.getString());
                    continue;
                }
                if ("excludedKbNumbers".equals(fieldName)) {
                    List excludedKbNumbers;
                    deserializedWindowsProperties.excludedKbNumbers = excludedKbNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("includedKbNumbers".equals(fieldName)) {
                    List includedKbNumbers;
                    deserializedWindowsProperties.includedKbNumbers = includedKbNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("rebootSetting".equals(fieldName)) {
                    deserializedWindowsProperties.rebootSetting = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWindowsProperties;
        });
    }
}

