/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.OperationDisplay;
import com.azure.resourcemanager.azurearcdata.models.OperationOrigin;
import java.io.IOException;
import java.util.Map;

public final class OperationInner
implements JsonSerializable<OperationInner> {
    private String name;
    private OperationDisplay display;
    private OperationOrigin origin;
    private boolean isDataAction;
    private Map<String, Object> properties;
    private static final ClientLogger LOGGER = new ClientLogger(OperationInner.class);

    public String name() {
        return this.name;
    }

    public OperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public OperationOrigin origin() {
        return this.origin;
    }

    public boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationInner withIsDataAction(boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model OperationInner"));
        }
        if (this.display() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property display in model OperationInner"));
        }
        this.display().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInner)jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationInner.isDataAction = reader.getBoolean();
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = OperationOrigin.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedOperationInner.properties = properties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInner;
        });
    }
}

