/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.ExtendedLocation;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceProperties;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceSku;
import java.io.IOException;
import java.util.Map;

public final class SqlManagedInstanceInner
extends Resource {
    private SqlManagedInstanceProperties properties;
    private ExtendedLocation extendedLocation;
    private SqlManagedInstanceSku sku;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SqlManagedInstanceInner.class);

    public SqlManagedInstanceProperties properties() {
        return this.properties;
    }

    public SqlManagedInstanceInner withProperties(SqlManagedInstanceProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public SqlManagedInstanceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public SqlManagedInstanceSku sku() {
        return this.sku;
    }

    public SqlManagedInstanceInner withSku(SqlManagedInstanceSku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SqlManagedInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SqlManagedInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model SqlManagedInstanceInner"));
        }
        this.properties().validate();
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static SqlManagedInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return (SqlManagedInstanceInner)((Object)jsonReader.readObject(reader -> {
            SqlManagedInstanceInner deserializedSqlManagedInstanceInner = new SqlManagedInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlManagedInstanceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.properties = SqlManagedInstanceProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.sku = SqlManagedInstanceSku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSqlManagedInstanceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlManagedInstanceInner;
        }));
    }
}

