/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.SqlServerInstanceProperties;
import java.io.IOException;
import java.util.Map;

public final class SqlServerInstanceInner
extends Resource {
    private SqlServerInstanceProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public SqlServerInstanceProperties properties() {
        return this.properties;
    }

    public SqlServerInstanceInner withProperties(SqlServerInstanceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SqlServerInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SqlServerInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static SqlServerInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerInstanceInner)((Object)jsonReader.readObject(reader -> {
            SqlServerInstanceInner deserializedSqlServerInstanceInner = new SqlServerInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlServerInstanceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlServerInstanceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlServerInstanceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSqlServerInstanceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlServerInstanceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSqlServerInstanceInner.properties = SqlServerInstanceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSqlServerInstanceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlServerInstanceInner;
        }));
    }
}

