/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurearcdata.AzureArcDataManager;
import com.azure.resourcemanager.azurearcdata.fluent.models.DataControllerResourceInner;
import com.azure.resourcemanager.azurearcdata.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurearcdata.models.DataControllerProperties;
import com.azure.resourcemanager.azurearcdata.models.DataControllerResource;
import com.azure.resourcemanager.azurearcdata.models.DataControllerUpdate;
import com.azure.resourcemanager.azurearcdata.models.ExtendedLocation;
import java.util.Collections;
import java.util.Map;

public final class DataControllerResourceImpl
implements DataControllerResource,
DataControllerResource.Definition,
DataControllerResource.Update {
    private DataControllerResourceInner innerObject;
    private final AzureArcDataManager serviceManager;
    private String resourceGroupName;
    private String dataControllerName;
    private DataControllerUpdate updateDataControllerResource;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public DataControllerProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DataControllerResourceInner innerModel() {
        return this.innerObject;
    }

    private AzureArcDataManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataControllerResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DataControllerResource create() {
        this.innerObject = this.serviceManager.serviceClient().getDataControllers().putDataController(this.resourceGroupName, this.dataControllerName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DataControllerResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDataControllers().putDataController(this.resourceGroupName, this.dataControllerName, this.innerModel(), context);
        return this;
    }

    DataControllerResourceImpl(String name, AzureArcDataManager serviceManager) {
        this.innerObject = new DataControllerResourceInner();
        this.serviceManager = serviceManager;
        this.dataControllerName = name;
    }

    @Override
    public DataControllerResourceImpl update() {
        this.updateDataControllerResource = new DataControllerUpdate();
        return this;
    }

    @Override
    public DataControllerResource apply() {
        this.innerObject = (DataControllerResourceInner)((Object)this.serviceManager.serviceClient().getDataControllers().patchDataControllerWithResponse(this.resourceGroupName, this.dataControllerName, this.updateDataControllerResource, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataControllerResource apply(Context context) {
        this.innerObject = (DataControllerResourceInner)((Object)this.serviceManager.serviceClient().getDataControllers().patchDataControllerWithResponse(this.resourceGroupName, this.dataControllerName, this.updateDataControllerResource, context).getValue());
        return this;
    }

    DataControllerResourceImpl(DataControllerResourceInner innerObject, AzureArcDataManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dataControllerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dataControllers");
    }

    @Override
    public DataControllerResource refresh() {
        this.innerObject = (DataControllerResourceInner)((Object)this.serviceManager.serviceClient().getDataControllers().getByResourceGroupWithResponse(this.resourceGroupName, this.dataControllerName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DataControllerResource refresh(Context context) {
        this.innerObject = (DataControllerResourceInner)((Object)this.serviceManager.serviceClient().getDataControllers().getByResourceGroupWithResponse(this.resourceGroupName, this.dataControllerName, context).getValue());
        return this;
    }

    @Override
    public DataControllerResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DataControllerResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DataControllerResourceImpl withProperties(DataControllerProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public DataControllerResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateDataControllerResource.withTags(tags);
        return this;
    }

    @Override
    public DataControllerResourceImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

