/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurearcdata.AzureArcDataManager;
import com.azure.resourcemanager.azurearcdata.fluent.DataControllersClient;
import com.azure.resourcemanager.azurearcdata.fluent.models.DataControllerResourceInner;
import com.azure.resourcemanager.azurearcdata.implementation.DataControllerResourceImpl;
import com.azure.resourcemanager.azurearcdata.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurearcdata.models.DataControllerResource;
import com.azure.resourcemanager.azurearcdata.models.DataControllers;

public final class DataControllersImpl
implements DataControllers {
    private static final ClientLogger LOGGER = new ClientLogger(DataControllersImpl.class);
    private final DataControllersClient innerClient;
    private final AzureArcDataManager serviceManager;

    public DataControllersImpl(DataControllersClient innerClient, AzureArcDataManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DataControllerResource> list() {
        PagedIterable<DataControllerResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataControllerResourceImpl((DataControllerResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataControllerResource> list(Context context) {
        PagedIterable<DataControllerResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataControllerResourceImpl((DataControllerResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataControllerResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DataControllerResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataControllerResourceImpl((DataControllerResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataControllerResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<DataControllerResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataControllerResourceImpl((DataControllerResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String dataControllerName) {
        this.serviceClient().delete(resourceGroupName, dataControllerName);
    }

    @Override
    public void delete(String resourceGroupName, String dataControllerName, Context context) {
        this.serviceClient().delete(resourceGroupName, dataControllerName, context);
    }

    @Override
    public Response<DataControllerResource> getByResourceGroupWithResponse(String resourceGroupName, String dataControllerName, Context context) {
        Response<DataControllerResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, dataControllerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DataControllerResourceImpl((DataControllerResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DataControllerResource getByResourceGroup(String resourceGroupName, String dataControllerName) {
        DataControllerResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, dataControllerName);
        if (inner != null) {
            return new DataControllerResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DataControllerResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dataControllerName = ResourceManagerUtils.getValueFromIdByName(id, "dataControllers");
        if (dataControllerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataControllers'.", id)));
        }
        return (DataControllerResource)this.getByResourceGroupWithResponse(resourceGroupName, dataControllerName, Context.NONE).getValue();
    }

    @Override
    public Response<DataControllerResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dataControllerName = ResourceManagerUtils.getValueFromIdByName(id, "dataControllers");
        if (dataControllerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataControllers'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, dataControllerName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dataControllerName = ResourceManagerUtils.getValueFromIdByName(id, "dataControllers");
        if (dataControllerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataControllers'.", id)));
        }
        this.delete(resourceGroupName, dataControllerName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dataControllerName = ResourceManagerUtils.getValueFromIdByName(id, "dataControllers");
        if (dataControllerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dataControllers'.", id)));
        }
        this.delete(resourceGroupName, dataControllerName, context);
    }

    private DataControllersClient serviceClient() {
        return this.innerClient;
    }

    private AzureArcDataManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataControllerResourceImpl define(String name) {
        return new DataControllerResourceImpl(name, this.manager());
    }
}

