/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurearcdata.AzureArcDataManager;
import com.azure.resourcemanager.azurearcdata.fluent.models.SqlManagedInstanceInner;
import com.azure.resourcemanager.azurearcdata.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurearcdata.models.ExtendedLocation;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstance;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceProperties;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceSku;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceUpdate;
import java.util.Collections;
import java.util.Map;

public final class SqlManagedInstanceImpl
implements SqlManagedInstance,
SqlManagedInstance.Definition,
SqlManagedInstance.Update {
    private SqlManagedInstanceInner innerObject;
    private final AzureArcDataManager serviceManager;
    private String resourceGroupName;
    private String sqlManagedInstanceName;
    private SqlManagedInstanceUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SqlManagedInstanceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SqlManagedInstanceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SqlManagedInstanceInner innerModel() {
        return this.innerObject;
    }

    private AzureArcDataManager manager() {
        return this.serviceManager;
    }

    @Override
    public SqlManagedInstanceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SqlManagedInstance create() {
        this.innerObject = this.serviceManager.serviceClient().getSqlManagedInstances().create(this.resourceGroupName, this.sqlManagedInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SqlManagedInstance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSqlManagedInstances().create(this.resourceGroupName, this.sqlManagedInstanceName, this.innerModel(), context);
        return this;
    }

    SqlManagedInstanceImpl(String name, AzureArcDataManager serviceManager) {
        this.innerObject = new SqlManagedInstanceInner();
        this.serviceManager = serviceManager;
        this.sqlManagedInstanceName = name;
    }

    @Override
    public SqlManagedInstanceImpl update() {
        this.updateParameters = new SqlManagedInstanceUpdate();
        return this;
    }

    @Override
    public SqlManagedInstance apply() {
        this.innerObject = (SqlManagedInstanceInner)((Object)this.serviceManager.serviceClient().getSqlManagedInstances().updateWithResponse(this.resourceGroupName, this.sqlManagedInstanceName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public SqlManagedInstance apply(Context context) {
        this.innerObject = (SqlManagedInstanceInner)((Object)this.serviceManager.serviceClient().getSqlManagedInstances().updateWithResponse(this.resourceGroupName, this.sqlManagedInstanceName, this.updateParameters, context).getValue());
        return this;
    }

    SqlManagedInstanceImpl(SqlManagedInstanceInner innerObject, AzureArcDataManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sqlManagedInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sqlManagedInstances");
    }

    @Override
    public SqlManagedInstance refresh() {
        this.innerObject = (SqlManagedInstanceInner)((Object)this.serviceManager.serviceClient().getSqlManagedInstances().getByResourceGroupWithResponse(this.resourceGroupName, this.sqlManagedInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SqlManagedInstance refresh(Context context) {
        this.innerObject = (SqlManagedInstanceInner)((Object)this.serviceManager.serviceClient().getSqlManagedInstances().getByResourceGroupWithResponse(this.resourceGroupName, this.sqlManagedInstanceName, context).getValue());
        return this;
    }

    @Override
    public SqlManagedInstanceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SqlManagedInstanceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SqlManagedInstanceImpl withProperties(SqlManagedInstanceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SqlManagedInstanceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public SqlManagedInstanceImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public SqlManagedInstanceImpl withSku(SqlManagedInstanceSku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

