/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurearcdata.AzureArcDataManager;
import com.azure.resourcemanager.azurearcdata.fluent.SqlManagedInstancesClient;
import com.azure.resourcemanager.azurearcdata.fluent.models.SqlManagedInstanceInner;
import com.azure.resourcemanager.azurearcdata.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurearcdata.implementation.SqlManagedInstanceImpl;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstance;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstances;

public final class SqlManagedInstancesImpl
implements SqlManagedInstances {
    private static final ClientLogger LOGGER = new ClientLogger(SqlManagedInstancesImpl.class);
    private final SqlManagedInstancesClient innerClient;
    private final AzureArcDataManager serviceManager;

    public SqlManagedInstancesImpl(SqlManagedInstancesClient innerClient, AzureArcDataManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SqlManagedInstance> list() {
        PagedIterable<SqlManagedInstanceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlManagedInstanceImpl((SqlManagedInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SqlManagedInstance> list(Context context) {
        PagedIterable<SqlManagedInstanceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlManagedInstanceImpl((SqlManagedInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SqlManagedInstance> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SqlManagedInstanceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlManagedInstanceImpl((SqlManagedInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SqlManagedInstance> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SqlManagedInstanceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlManagedInstanceImpl((SqlManagedInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SqlManagedInstance> getByResourceGroupWithResponse(String resourceGroupName, String sqlManagedInstanceName, Context context) {
        Response<SqlManagedInstanceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, sqlManagedInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SqlManagedInstanceImpl((SqlManagedInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SqlManagedInstance getByResourceGroup(String resourceGroupName, String sqlManagedInstanceName) {
        SqlManagedInstanceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, sqlManagedInstanceName);
        if (inner != null) {
            return new SqlManagedInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String sqlManagedInstanceName) {
        this.serviceClient().delete(resourceGroupName, sqlManagedInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String sqlManagedInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, sqlManagedInstanceName, context);
    }

    @Override
    public SqlManagedInstance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlManagedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlManagedInstances");
        if (sqlManagedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlManagedInstances'.", id)));
        }
        return (SqlManagedInstance)this.getByResourceGroupWithResponse(resourceGroupName, sqlManagedInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<SqlManagedInstance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlManagedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlManagedInstances");
        if (sqlManagedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlManagedInstances'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, sqlManagedInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlManagedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlManagedInstances");
        if (sqlManagedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlManagedInstances'.", id)));
        }
        this.delete(resourceGroupName, sqlManagedInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlManagedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlManagedInstances");
        if (sqlManagedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlManagedInstances'.", id)));
        }
        this.delete(resourceGroupName, sqlManagedInstanceName, context);
    }

    private SqlManagedInstancesClient serviceClient() {
        return this.innerClient;
    }

    private AzureArcDataManager manager() {
        return this.serviceManager;
    }

    @Override
    public SqlManagedInstanceImpl define(String name) {
        return new SqlManagedInstanceImpl(name, this.manager());
    }
}

