/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurearcdata.AzureArcDataManager;
import com.azure.resourcemanager.azurearcdata.fluent.models.SqlServerInstanceInner;
import com.azure.resourcemanager.azurearcdata.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurearcdata.models.SqlServerInstance;
import com.azure.resourcemanager.azurearcdata.models.SqlServerInstanceProperties;
import com.azure.resourcemanager.azurearcdata.models.SqlServerInstanceUpdate;
import java.util.Collections;
import java.util.Map;

public final class SqlServerInstanceImpl
implements SqlServerInstance,
SqlServerInstance.Definition,
SqlServerInstance.Update {
    private SqlServerInstanceInner innerObject;
    private final AzureArcDataManager serviceManager;
    private String resourceGroupName;
    private String sqlServerInstanceName;
    private SqlServerInstanceUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SqlServerInstanceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SqlServerInstanceInner innerModel() {
        return this.innerObject;
    }

    private AzureArcDataManager manager() {
        return this.serviceManager;
    }

    @Override
    public SqlServerInstanceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SqlServerInstance create() {
        this.innerObject = this.serviceManager.serviceClient().getSqlServerInstances().create(this.resourceGroupName, this.sqlServerInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SqlServerInstance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSqlServerInstances().create(this.resourceGroupName, this.sqlServerInstanceName, this.innerModel(), context);
        return this;
    }

    SqlServerInstanceImpl(String name, AzureArcDataManager serviceManager) {
        this.innerObject = new SqlServerInstanceInner();
        this.serviceManager = serviceManager;
        this.sqlServerInstanceName = name;
    }

    @Override
    public SqlServerInstanceImpl update() {
        this.updateParameters = new SqlServerInstanceUpdate();
        return this;
    }

    @Override
    public SqlServerInstance apply() {
        this.innerObject = (SqlServerInstanceInner)((Object)this.serviceManager.serviceClient().getSqlServerInstances().updateWithResponse(this.resourceGroupName, this.sqlServerInstanceName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public SqlServerInstance apply(Context context) {
        this.innerObject = (SqlServerInstanceInner)((Object)this.serviceManager.serviceClient().getSqlServerInstances().updateWithResponse(this.resourceGroupName, this.sqlServerInstanceName, this.updateParameters, context).getValue());
        return this;
    }

    SqlServerInstanceImpl(SqlServerInstanceInner innerObject, AzureArcDataManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sqlServerInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sqlServerInstances");
    }

    @Override
    public SqlServerInstance refresh() {
        this.innerObject = (SqlServerInstanceInner)((Object)this.serviceManager.serviceClient().getSqlServerInstances().getByResourceGroupWithResponse(this.resourceGroupName, this.sqlServerInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SqlServerInstance refresh(Context context) {
        this.innerObject = (SqlServerInstanceInner)((Object)this.serviceManager.serviceClient().getSqlServerInstances().getByResourceGroupWithResponse(this.resourceGroupName, this.sqlServerInstanceName, context).getValue());
        return this;
    }

    @Override
    public SqlServerInstanceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SqlServerInstanceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SqlServerInstanceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public SqlServerInstanceImpl withProperties(SqlServerInstanceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

