/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurearcdata.AzureArcDataManager;
import com.azure.resourcemanager.azurearcdata.fluent.SqlServerInstancesClient;
import com.azure.resourcemanager.azurearcdata.fluent.models.SqlServerInstanceInner;
import com.azure.resourcemanager.azurearcdata.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurearcdata.implementation.SqlServerInstanceImpl;
import com.azure.resourcemanager.azurearcdata.models.SqlServerInstance;
import com.azure.resourcemanager.azurearcdata.models.SqlServerInstances;

public final class SqlServerInstancesImpl
implements SqlServerInstances {
    private static final ClientLogger LOGGER = new ClientLogger(SqlServerInstancesImpl.class);
    private final SqlServerInstancesClient innerClient;
    private final AzureArcDataManager serviceManager;

    public SqlServerInstancesImpl(SqlServerInstancesClient innerClient, AzureArcDataManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SqlServerInstance> list() {
        PagedIterable<SqlServerInstanceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlServerInstanceImpl((SqlServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SqlServerInstance> list(Context context) {
        PagedIterable<SqlServerInstanceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlServerInstanceImpl((SqlServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SqlServerInstance> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SqlServerInstanceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlServerInstanceImpl((SqlServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SqlServerInstance> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SqlServerInstanceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SqlServerInstanceImpl((SqlServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SqlServerInstance> getByResourceGroupWithResponse(String resourceGroupName, String sqlServerInstanceName, Context context) {
        Response<SqlServerInstanceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, sqlServerInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SqlServerInstanceImpl((SqlServerInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SqlServerInstance getByResourceGroup(String resourceGroupName, String sqlServerInstanceName) {
        SqlServerInstanceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, sqlServerInstanceName);
        if (inner != null) {
            return new SqlServerInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String sqlServerInstanceName) {
        this.serviceClient().delete(resourceGroupName, sqlServerInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String sqlServerInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, sqlServerInstanceName, context);
    }

    @Override
    public SqlServerInstance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlServerInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlServerInstances");
        if (sqlServerInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlServerInstances'.", id)));
        }
        return (SqlServerInstance)this.getByResourceGroupWithResponse(resourceGroupName, sqlServerInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<SqlServerInstance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlServerInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlServerInstances");
        if (sqlServerInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlServerInstances'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, sqlServerInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlServerInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlServerInstances");
        if (sqlServerInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlServerInstances'.", id)));
        }
        this.delete(resourceGroupName, sqlServerInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sqlServerInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sqlServerInstances");
        if (sqlServerInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sqlServerInstances'.", id)));
        }
        this.delete(resourceGroupName, sqlServerInstanceName, context);
    }

    private SqlServerInstancesClient serviceClient() {
        return this.innerClient;
    }

    private AzureArcDataManager manager() {
        return this.serviceManager;
    }

    @Override
    public SqlServerInstanceImpl define(String name) {
        return new SqlServerInstanceImpl(name, this.manager());
    }
}

