/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.BasicLoginInformation;
import com.azure.resourcemanager.azurearcdata.models.Infrastructure;
import com.azure.resourcemanager.azurearcdata.models.LogAnalyticsWorkspaceConfig;
import com.azure.resourcemanager.azurearcdata.models.OnPremiseProperty;
import com.azure.resourcemanager.azurearcdata.models.UploadServicePrincipal;
import com.azure.resourcemanager.azurearcdata.models.UploadWatermark;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DataControllerProperties
implements JsonSerializable<DataControllerProperties> {
    private Infrastructure infrastructure;
    private OnPremiseProperty onPremiseProperty;
    private Object k8SRaw;
    private UploadWatermark uploadWatermark;
    private OffsetDateTime lastUploadedDate;
    private BasicLoginInformation basicLoginInformation;
    private LogAnalyticsWorkspaceConfig logAnalyticsWorkspaceConfig;
    private UploadServicePrincipal uploadServicePrincipal;
    private String provisioningState;
    private String clusterId;
    private String extensionId;

    public Infrastructure infrastructure() {
        return this.infrastructure;
    }

    public DataControllerProperties withInfrastructure(Infrastructure infrastructure) {
        this.infrastructure = infrastructure;
        return this;
    }

    public OnPremiseProperty onPremiseProperty() {
        return this.onPremiseProperty;
    }

    public DataControllerProperties withOnPremiseProperty(OnPremiseProperty onPremiseProperty) {
        this.onPremiseProperty = onPremiseProperty;
        return this;
    }

    public Object k8SRaw() {
        return this.k8SRaw;
    }

    public DataControllerProperties withK8SRaw(Object k8SRaw) {
        this.k8SRaw = k8SRaw;
        return this;
    }

    public UploadWatermark uploadWatermark() {
        return this.uploadWatermark;
    }

    public DataControllerProperties withUploadWatermark(UploadWatermark uploadWatermark) {
        this.uploadWatermark = uploadWatermark;
        return this;
    }

    public OffsetDateTime lastUploadedDate() {
        return this.lastUploadedDate;
    }

    public DataControllerProperties withLastUploadedDate(OffsetDateTime lastUploadedDate) {
        this.lastUploadedDate = lastUploadedDate;
        return this;
    }

    public BasicLoginInformation basicLoginInformation() {
        return this.basicLoginInformation;
    }

    public DataControllerProperties withBasicLoginInformation(BasicLoginInformation basicLoginInformation) {
        this.basicLoginInformation = basicLoginInformation;
        return this;
    }

    public LogAnalyticsWorkspaceConfig logAnalyticsWorkspaceConfig() {
        return this.logAnalyticsWorkspaceConfig;
    }

    public DataControllerProperties withLogAnalyticsWorkspaceConfig(LogAnalyticsWorkspaceConfig logAnalyticsWorkspaceConfig) {
        this.logAnalyticsWorkspaceConfig = logAnalyticsWorkspaceConfig;
        return this;
    }

    public UploadServicePrincipal uploadServicePrincipal() {
        return this.uploadServicePrincipal;
    }

    public DataControllerProperties withUploadServicePrincipal(UploadServicePrincipal uploadServicePrincipal) {
        this.uploadServicePrincipal = uploadServicePrincipal;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public DataControllerProperties withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String extensionId() {
        return this.extensionId;
    }

    public DataControllerProperties withExtensionId(String extensionId) {
        this.extensionId = extensionId;
        return this;
    }

    public void validate() {
        if (this.onPremiseProperty() != null) {
            this.onPremiseProperty().validate();
        }
        if (this.uploadWatermark() != null) {
            this.uploadWatermark().validate();
        }
        if (this.basicLoginInformation() != null) {
            this.basicLoginInformation().validate();
        }
        if (this.logAnalyticsWorkspaceConfig() != null) {
            this.logAnalyticsWorkspaceConfig().validate();
        }
        if (this.uploadServicePrincipal() != null) {
            this.uploadServicePrincipal().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("infrastructure", this.infrastructure == null ? null : this.infrastructure.toString());
        jsonWriter.writeJsonField("onPremiseProperty", (JsonSerializable)this.onPremiseProperty);
        jsonWriter.writeUntypedField("k8sRaw", this.k8SRaw);
        jsonWriter.writeJsonField("uploadWatermark", (JsonSerializable)this.uploadWatermark);
        jsonWriter.writeStringField("lastUploadedDate", this.lastUploadedDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUploadedDate));
        jsonWriter.writeJsonField("basicLoginInformation", (JsonSerializable)this.basicLoginInformation);
        jsonWriter.writeJsonField("logAnalyticsWorkspaceConfig", (JsonSerializable)this.logAnalyticsWorkspaceConfig);
        jsonWriter.writeJsonField("uploadServicePrincipal", (JsonSerializable)this.uploadServicePrincipal);
        jsonWriter.writeStringField("clusterId", this.clusterId);
        jsonWriter.writeStringField("extensionId", this.extensionId);
        return jsonWriter.writeEndObject();
    }

    public static DataControllerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataControllerProperties)jsonReader.readObject(reader -> {
            DataControllerProperties deserializedDataControllerProperties = new DataControllerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("infrastructure".equals(fieldName)) {
                    deserializedDataControllerProperties.infrastructure = Infrastructure.fromString(reader.getString());
                    continue;
                }
                if ("onPremiseProperty".equals(fieldName)) {
                    deserializedDataControllerProperties.onPremiseProperty = OnPremiseProperty.fromJson(reader);
                    continue;
                }
                if ("k8sRaw".equals(fieldName)) {
                    deserializedDataControllerProperties.k8SRaw = reader.readUntyped();
                    continue;
                }
                if ("uploadWatermark".equals(fieldName)) {
                    deserializedDataControllerProperties.uploadWatermark = UploadWatermark.fromJson(reader);
                    continue;
                }
                if ("lastUploadedDate".equals(fieldName)) {
                    deserializedDataControllerProperties.lastUploadedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("basicLoginInformation".equals(fieldName)) {
                    deserializedDataControllerProperties.basicLoginInformation = BasicLoginInformation.fromJson(reader);
                    continue;
                }
                if ("logAnalyticsWorkspaceConfig".equals(fieldName)) {
                    deserializedDataControllerProperties.logAnalyticsWorkspaceConfig = LogAnalyticsWorkspaceConfig.fromJson(reader);
                    continue;
                }
                if ("uploadServicePrincipal".equals(fieldName)) {
                    deserializedDataControllerProperties.uploadServicePrincipal = UploadServicePrincipal.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataControllerProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedDataControllerProperties.clusterId = reader.getString();
                    continue;
                }
                if ("extensionId".equals(fieldName)) {
                    deserializedDataControllerProperties.extensionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataControllerProperties;
        });
    }
}

