/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class OnPremiseProperty
implements JsonSerializable<OnPremiseProperty> {
    private UUID id;
    private String publicSigningKey;
    private String signingCertificateThumbprint;
    private static final ClientLogger LOGGER = new ClientLogger(OnPremiseProperty.class);

    public UUID id() {
        return this.id;
    }

    public OnPremiseProperty withId(UUID id) {
        this.id = id;
        return this;
    }

    public String publicSigningKey() {
        return this.publicSigningKey;
    }

    public OnPremiseProperty withPublicSigningKey(String publicSigningKey) {
        this.publicSigningKey = publicSigningKey;
        return this;
    }

    public String signingCertificateThumbprint() {
        return this.signingCertificateThumbprint;
    }

    public OnPremiseProperty withSigningCertificateThumbprint(String signingCertificateThumbprint) {
        this.signingCertificateThumbprint = signingCertificateThumbprint;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model OnPremiseProperty"));
        }
        if (this.publicSigningKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publicSigningKey in model OnPremiseProperty"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", Objects.toString(this.id, null));
        jsonWriter.writeStringField("publicSigningKey", this.publicSigningKey);
        jsonWriter.writeStringField("signingCertificateThumbprint", this.signingCertificateThumbprint);
        return jsonWriter.writeEndObject();
    }

    public static OnPremiseProperty fromJson(JsonReader jsonReader) throws IOException {
        return (OnPremiseProperty)jsonReader.readObject(reader -> {
            OnPremiseProperty deserializedOnPremiseProperty = new OnPremiseProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOnPremiseProperty.id = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("publicSigningKey".equals(fieldName)) {
                    deserializedOnPremiseProperty.publicSigningKey = reader.getString();
                    continue;
                }
                if ("signingCertificateThumbprint".equals(fieldName)) {
                    deserializedOnPremiseProperty.signingCertificateThumbprint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOnPremiseProperty;
        });
    }
}

