/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OperationDisplay
implements JsonSerializable<OperationDisplay> {
    private String provider;
    private String resource;
    private String operation;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(OperationDisplay.class);

    public String provider() {
        return this.provider;
    }

    public OperationDisplay withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String resource() {
        return this.resource;
    }

    public OperationDisplay withResource(String resource) {
        this.resource = resource;
        return this;
    }

    public String operation() {
        return this.operation;
    }

    public OperationDisplay withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public String description() {
        return this.description;
    }

    public OperationDisplay withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.provider() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property provider in model OperationDisplay"));
        }
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model OperationDisplay"));
        }
        if (this.operation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operation in model OperationDisplay"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model OperationDisplay"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("resource", this.resource);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static OperationDisplay fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDisplay)jsonReader.readObject(reader -> {
            OperationDisplay deserializedOperationDisplay = new OperationDisplay();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    deserializedOperationDisplay.provider = reader.getString();
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedOperationDisplay.resource = reader.getString();
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedOperationDisplay.operation = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOperationDisplay.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationDisplay;
        });
    }
}

