/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurearcdata.fluent.models.SqlManagedInstanceInner;
import com.azure.resourcemanager.azurearcdata.models.ExtendedLocation;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceProperties;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceSku;
import java.util.Map;

public interface SqlManagedInstance {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SqlManagedInstanceProperties properties();

    public ExtendedLocation extendedLocation();

    public SqlManagedInstanceSku sku();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public SqlManagedInstanceInner innerModel();

    public Update update();

    public SqlManagedInstance refresh();

    public SqlManagedInstance refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public SqlManagedInstance apply();

        public SqlManagedInstance apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSku {
            public WithCreate withSku(SqlManagedInstanceSku var1);
        }

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithExtendedLocation,
        WithSku {
            public SqlManagedInstance create();

            public SqlManagedInstance create(Context var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(SqlManagedInstanceProperties var1);
        }

        public static interface WithResourceGroup {
            public WithProperties withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithProperties,
    DefinitionStages.WithCreate {
    }
}

