/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.K8SScheduling;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlManagedInstanceK8SSpec
implements JsonSerializable<SqlManagedInstanceK8SSpec> {
    private K8SScheduling scheduling;
    private Integer replicas;
    private Map<String, Object> additionalProperties;

    public K8SScheduling scheduling() {
        return this.scheduling;
    }

    public SqlManagedInstanceK8SSpec withScheduling(K8SScheduling scheduling) {
        this.scheduling = scheduling;
        return this;
    }

    public Integer replicas() {
        return this.replicas;
    }

    public SqlManagedInstanceK8SSpec withReplicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public SqlManagedInstanceK8SSpec withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.scheduling() != null) {
            this.scheduling().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scheduling", (JsonSerializable)this.scheduling);
        jsonWriter.writeNumberField("replicas", (Number)this.replicas);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlManagedInstanceK8SSpec fromJson(JsonReader jsonReader) throws IOException {
        return (SqlManagedInstanceK8SSpec)jsonReader.readObject(reader -> {
            SqlManagedInstanceK8SSpec deserializedSqlManagedInstanceK8SSpec = new SqlManagedInstanceK8SSpec();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduling".equals(fieldName)) {
                    deserializedSqlManagedInstanceK8SSpec.scheduling = K8SScheduling.fromJson(reader);
                    continue;
                }
                if ("replicas".equals(fieldName)) {
                    deserializedSqlManagedInstanceK8SSpec.replicas = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlManagedInstanceK8SSpec.additionalProperties = additionalProperties;
            return deserializedSqlManagedInstanceK8SSpec;
        });
    }
}

