/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.ArcSqlManagedInstanceLicenseType;
import com.azure.resourcemanager.azurearcdata.models.BasicLoginInformation;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceK8SRaw;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SqlManagedInstanceProperties
implements JsonSerializable<SqlManagedInstanceProperties> {
    private String dataControllerId;
    private String admin;
    private String startTime;
    private String endTime;
    private SqlManagedInstanceK8SRaw k8SRaw;
    private BasicLoginInformation basicLoginInformation;
    private OffsetDateTime lastUploadedDate;
    private String provisioningState;
    private ArcSqlManagedInstanceLicenseType licenseType;
    private String clusterId;
    private String extensionId;

    public String dataControllerId() {
        return this.dataControllerId;
    }

    public SqlManagedInstanceProperties withDataControllerId(String dataControllerId) {
        this.dataControllerId = dataControllerId;
        return this;
    }

    public String admin() {
        return this.admin;
    }

    public SqlManagedInstanceProperties withAdmin(String admin) {
        this.admin = admin;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public SqlManagedInstanceProperties withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public SqlManagedInstanceProperties withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public SqlManagedInstanceK8SRaw k8SRaw() {
        return this.k8SRaw;
    }

    public SqlManagedInstanceProperties withK8SRaw(SqlManagedInstanceK8SRaw k8SRaw) {
        this.k8SRaw = k8SRaw;
        return this;
    }

    public BasicLoginInformation basicLoginInformation() {
        return this.basicLoginInformation;
    }

    public SqlManagedInstanceProperties withBasicLoginInformation(BasicLoginInformation basicLoginInformation) {
        this.basicLoginInformation = basicLoginInformation;
        return this;
    }

    public OffsetDateTime lastUploadedDate() {
        return this.lastUploadedDate;
    }

    public SqlManagedInstanceProperties withLastUploadedDate(OffsetDateTime lastUploadedDate) {
        this.lastUploadedDate = lastUploadedDate;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public ArcSqlManagedInstanceLicenseType licenseType() {
        return this.licenseType;
    }

    public SqlManagedInstanceProperties withLicenseType(ArcSqlManagedInstanceLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public SqlManagedInstanceProperties withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String extensionId() {
        return this.extensionId;
    }

    public SqlManagedInstanceProperties withExtensionId(String extensionId) {
        this.extensionId = extensionId;
        return this;
    }

    public void validate() {
        if (this.k8SRaw() != null) {
            this.k8SRaw().validate();
        }
        if (this.basicLoginInformation() != null) {
            this.basicLoginInformation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataControllerId", this.dataControllerId);
        jsonWriter.writeStringField("admin", this.admin);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeJsonField("k8sRaw", (JsonSerializable)this.k8SRaw);
        jsonWriter.writeJsonField("basicLoginInformation", (JsonSerializable)this.basicLoginInformation);
        jsonWriter.writeStringField("lastUploadedDate", this.lastUploadedDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUploadedDate));
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("clusterId", this.clusterId);
        jsonWriter.writeStringField("extensionId", this.extensionId);
        return jsonWriter.writeEndObject();
    }

    public static SqlManagedInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlManagedInstanceProperties)jsonReader.readObject(reader -> {
            SqlManagedInstanceProperties deserializedSqlManagedInstanceProperties = new SqlManagedInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataControllerId".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.dataControllerId = reader.getString();
                    continue;
                }
                if ("admin".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.admin = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.endTime = reader.getString();
                    continue;
                }
                if ("k8sRaw".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.k8SRaw = SqlManagedInstanceK8SRaw.fromJson(reader);
                    continue;
                }
                if ("basicLoginInformation".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.basicLoginInformation = BasicLoginInformation.fromJson(reader);
                    continue;
                }
                if ("lastUploadedDate".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.lastUploadedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.licenseType = ArcSqlManagedInstanceLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.clusterId = reader.getString();
                    continue;
                }
                if ("extensionId".equals(fieldName)) {
                    deserializedSqlManagedInstanceProperties.extensionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlManagedInstanceProperties;
        });
    }
}

