/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.SqlManagedInstanceSkuTier;
import java.io.IOException;

public final class SqlManagedInstanceSku
implements JsonSerializable<SqlManagedInstanceSku> {
    private final String name = "vCore";
    private SqlManagedInstanceSkuTier tier;
    private Boolean dev;
    private String size;
    private String family;
    private Integer capacity;

    public String name() {
        return this.name;
    }

    public SqlManagedInstanceSkuTier tier() {
        return this.tier;
    }

    public SqlManagedInstanceSku withTier(SqlManagedInstanceSkuTier tier) {
        this.tier = tier;
        return this;
    }

    public Boolean dev() {
        return this.dev;
    }

    public SqlManagedInstanceSku withDev(Boolean dev) {
        this.dev = dev;
        return this;
    }

    public String size() {
        return this.size;
    }

    public SqlManagedInstanceSku withSize(String size) {
        this.size = size;
        return this;
    }

    public String family() {
        return this.family;
    }

    public SqlManagedInstanceSku withFamily(String family) {
        this.family = family;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public SqlManagedInstanceSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeBooleanField("dev", this.dev);
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static SqlManagedInstanceSku fromJson(JsonReader jsonReader) throws IOException {
        return (SqlManagedInstanceSku)jsonReader.readObject(reader -> {
            SqlManagedInstanceSku deserializedSqlManagedInstanceSku = new SqlManagedInstanceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tier".equals(fieldName)) {
                    deserializedSqlManagedInstanceSku.tier = SqlManagedInstanceSkuTier.fromString(reader.getString());
                    continue;
                }
                if ("dev".equals(fieldName)) {
                    deserializedSqlManagedInstanceSku.dev = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedSqlManagedInstanceSku.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedSqlManagedInstanceSku.family = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSqlManagedInstanceSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlManagedInstanceSku;
        });
    }
}

