/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurearcdata.models.ArcSqlServerLicenseType;
import com.azure.resourcemanager.azurearcdata.models.ConnectionStatus;
import com.azure.resourcemanager.azurearcdata.models.DefenderStatus;
import com.azure.resourcemanager.azurearcdata.models.EditionType;
import com.azure.resourcemanager.azurearcdata.models.SqlVersion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SqlServerInstanceProperties
implements JsonSerializable<SqlServerInstanceProperties> {
    private SqlVersion version;
    private EditionType edition;
    private String containerResourceId;
    private String createTime;
    private String vCore;
    private ConnectionStatus status;
    private String patchLevel;
    private String collation;
    private String currentVersion;
    private String instanceName;
    private String tcpDynamicPorts;
    private String tcpStaticPorts;
    private String productId;
    private ArcSqlServerLicenseType licenseType;
    private OffsetDateTime azureDefenderStatusLastUpdated;
    private DefenderStatus azureDefenderStatus;
    private String provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SqlServerInstanceProperties.class);

    public SqlVersion version() {
        return this.version;
    }

    public SqlServerInstanceProperties withVersion(SqlVersion version) {
        this.version = version;
        return this;
    }

    public EditionType edition() {
        return this.edition;
    }

    public SqlServerInstanceProperties withEdition(EditionType edition) {
        this.edition = edition;
        return this;
    }

    public String containerResourceId() {
        return this.containerResourceId;
    }

    public SqlServerInstanceProperties withContainerResourceId(String containerResourceId) {
        this.containerResourceId = containerResourceId;
        return this;
    }

    public String createTime() {
        return this.createTime;
    }

    public String vCore() {
        return this.vCore;
    }

    public SqlServerInstanceProperties withVCore(String vCore) {
        this.vCore = vCore;
        return this;
    }

    public ConnectionStatus status() {
        return this.status;
    }

    public SqlServerInstanceProperties withStatus(ConnectionStatus status) {
        this.status = status;
        return this;
    }

    public String patchLevel() {
        return this.patchLevel;
    }

    public SqlServerInstanceProperties withPatchLevel(String patchLevel) {
        this.patchLevel = patchLevel;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public SqlServerInstanceProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public SqlServerInstanceProperties withCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public SqlServerInstanceProperties withInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String tcpDynamicPorts() {
        return this.tcpDynamicPorts;
    }

    public SqlServerInstanceProperties withTcpDynamicPorts(String tcpDynamicPorts) {
        this.tcpDynamicPorts = tcpDynamicPorts;
        return this;
    }

    public String tcpStaticPorts() {
        return this.tcpStaticPorts;
    }

    public SqlServerInstanceProperties withTcpStaticPorts(String tcpStaticPorts) {
        this.tcpStaticPorts = tcpStaticPorts;
        return this;
    }

    public String productId() {
        return this.productId;
    }

    public SqlServerInstanceProperties withProductId(String productId) {
        this.productId = productId;
        return this;
    }

    public ArcSqlServerLicenseType licenseType() {
        return this.licenseType;
    }

    public SqlServerInstanceProperties withLicenseType(ArcSqlServerLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public OffsetDateTime azureDefenderStatusLastUpdated() {
        return this.azureDefenderStatusLastUpdated;
    }

    public SqlServerInstanceProperties withAzureDefenderStatusLastUpdated(OffsetDateTime azureDefenderStatusLastUpdated) {
        this.azureDefenderStatusLastUpdated = azureDefenderStatusLastUpdated;
        return this;
    }

    public DefenderStatus azureDefenderStatus() {
        return this.azureDefenderStatus;
    }

    public SqlServerInstanceProperties withAzureDefenderStatus(DefenderStatus azureDefenderStatus) {
        this.azureDefenderStatus = azureDefenderStatus;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.containerResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerResourceId in model SqlServerInstanceProperties"));
        }
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model SqlServerInstanceProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerResourceId", this.containerResourceId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeStringField("edition", this.edition == null ? null : this.edition.toString());
        jsonWriter.writeStringField("vCore", this.vCore);
        jsonWriter.writeStringField("patchLevel", this.patchLevel);
        jsonWriter.writeStringField("collation", this.collation);
        jsonWriter.writeStringField("currentVersion", this.currentVersion);
        jsonWriter.writeStringField("instanceName", this.instanceName);
        jsonWriter.writeStringField("tcpDynamicPorts", this.tcpDynamicPorts);
        jsonWriter.writeStringField("tcpStaticPorts", this.tcpStaticPorts);
        jsonWriter.writeStringField("productId", this.productId);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("azureDefenderStatusLastUpdated", this.azureDefenderStatusLastUpdated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.azureDefenderStatusLastUpdated));
        jsonWriter.writeStringField("azureDefenderStatus", this.azureDefenderStatus == null ? null : this.azureDefenderStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static SqlServerInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerInstanceProperties)jsonReader.readObject(reader -> {
            SqlServerInstanceProperties deserializedSqlServerInstanceProperties = new SqlServerInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerResourceId".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.containerResourceId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.status = ConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.version = SqlVersion.fromString(reader.getString());
                    continue;
                }
                if ("edition".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.edition = EditionType.fromString(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.createTime = reader.getString();
                    continue;
                }
                if ("vCore".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.vCore = reader.getString();
                    continue;
                }
                if ("patchLevel".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.patchLevel = reader.getString();
                    continue;
                }
                if ("collation".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.collation = reader.getString();
                    continue;
                }
                if ("currentVersion".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.currentVersion = reader.getString();
                    continue;
                }
                if ("instanceName".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.instanceName = reader.getString();
                    continue;
                }
                if ("tcpDynamicPorts".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.tcpDynamicPorts = reader.getString();
                    continue;
                }
                if ("tcpStaticPorts".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.tcpStaticPorts = reader.getString();
                    continue;
                }
                if ("productId".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.productId = reader.getString();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.licenseType = ArcSqlServerLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("azureDefenderStatusLastUpdated".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.azureDefenderStatusLastUpdated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("azureDefenderStatus".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.azureDefenderStatus = DefenderStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSqlServerInstanceProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlServerInstanceProperties;
        });
    }
}

