/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class UploadServicePrincipal
implements JsonSerializable<UploadServicePrincipal> {
    private UUID clientId;
    private UUID tenantId;
    private String authority;
    private String clientSecret;

    public UUID clientId() {
        return this.clientId;
    }

    public UploadServicePrincipal withClientId(UUID clientId) {
        this.clientId = clientId;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public UploadServicePrincipal withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String authority() {
        return this.authority;
    }

    public UploadServicePrincipal withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public UploadServicePrincipal withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientId", Objects.toString(this.clientId, null));
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeStringField("authority", this.authority);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static UploadServicePrincipal fromJson(JsonReader jsonReader) throws IOException {
        return (UploadServicePrincipal)jsonReader.readObject(reader -> {
            UploadServicePrincipal deserializedUploadServicePrincipal = new UploadServicePrincipal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientId".equals(fieldName)) {
                    deserializedUploadServicePrincipal.clientId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedUploadServicePrincipal.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("authority".equals(fieldName)) {
                    deserializedUploadServicePrincipal.authority = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedUploadServicePrincipal.clientSecret = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUploadServicePrincipal;
        });
    }
}

