/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurearcdata.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class UploadWatermark
implements JsonSerializable<UploadWatermark> {
    private OffsetDateTime metrics;
    private OffsetDateTime logs;
    private OffsetDateTime usages;

    public OffsetDateTime metrics() {
        return this.metrics;
    }

    public UploadWatermark withMetrics(OffsetDateTime metrics) {
        this.metrics = metrics;
        return this;
    }

    public OffsetDateTime logs() {
        return this.logs;
    }

    public UploadWatermark withLogs(OffsetDateTime logs) {
        this.logs = logs;
        return this;
    }

    public OffsetDateTime usages() {
        return this.usages;
    }

    public UploadWatermark withUsages(OffsetDateTime usages) {
        this.usages = usages;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metrics", this.metrics == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.metrics));
        jsonWriter.writeStringField("logs", this.logs == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.logs));
        jsonWriter.writeStringField("usages", this.usages == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.usages));
        return jsonWriter.writeEndObject();
    }

    public static UploadWatermark fromJson(JsonReader jsonReader) throws IOException {
        return (UploadWatermark)jsonReader.readObject(reader -> {
            UploadWatermark deserializedUploadWatermark = new UploadWatermark();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metrics".equals(fieldName)) {
                    deserializedUploadWatermark.metrics = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("logs".equals(fieldName)) {
                    deserializedUploadWatermark.logs = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("usages".equals(fieldName)) {
                    deserializedUploadWatermark.usages = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUploadWatermark;
        });
    }
}

