// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.batch.models.PackageState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Properties of an application package.
 */
@Immutable
public final class ApplicationPackageProperties {
    /*
     * The current state of the application package.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private PackageState state;

    /*
     * The format of the application package, if the package is active.
     */
    @JsonProperty(value = "format", access = JsonProperty.Access.WRITE_ONLY)
    private String format;

    /*
     * The URL for the application package in Azure Storage.
     */
    @JsonProperty(value = "storageUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String storageUrl;

    /*
     * The UTC time at which the Azure Storage URL will expire.
     */
    @JsonProperty(value = "storageUrlExpiry", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime storageUrlExpiry;

    /*
     * The time at which the package was last activated, if the package is active.
     */
    @JsonProperty(value = "lastActivationTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastActivationTime;

    /**
     * Creates an instance of ApplicationPackageProperties class.
     */
    public ApplicationPackageProperties() {
    }

    /**
     * Get the state property: The current state of the application package.
     * 
     * @return the state value.
     */
    public PackageState state() {
        return this.state;
    }

    /**
     * Get the format property: The format of the application package, if the package is active.
     * 
     * @return the format value.
     */
    public String format() {
        return this.format;
    }

    /**
     * Get the storageUrl property: The URL for the application package in Azure Storage.
     * 
     * @return the storageUrl value.
     */
    public String storageUrl() {
        return this.storageUrl;
    }

    /**
     * Get the storageUrlExpiry property: The UTC time at which the Azure Storage URL will expire.
     * 
     * @return the storageUrlExpiry value.
     */
    public OffsetDateTime storageUrlExpiry() {
        return this.storageUrlExpiry;
    }

    /**
     * Get the lastActivationTime property: The time at which the package was last activated, if the package is active.
     * 
     * @return the lastActivationTime value.
     */
    public OffsetDateTime lastActivationTime() {
        return this.lastActivationTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
