// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The properties of a Batch account.
 */
@Fluent
public final class BatchAccountUpdateProperties {
    /*
     * The properties related to the auto-storage account.
     */
    @JsonProperty(value = "autoStorage")
    private AutoStorageBaseProperties autoStorage;

    /*
     * Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a
     * Microsoft managed key. For additional control, a customer-managed key can be used instead.
     */
    @JsonProperty(value = "encryption")
    private EncryptionProperties encryption;

    /*
     * List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane.
     * This does not affect authentication with the control plane.
     */
    @JsonProperty(value = "allowedAuthenticationModes")
    private List<AuthenticationMode> allowedAuthenticationModes;

    /*
     * If not specified, the default value is 'enabled'.
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccessType publicNetworkAccess;

    /*
     * The network profile only takes effect when publicNetworkAccess is enabled.
     */
    @JsonProperty(value = "networkProfile")
    private NetworkProfile networkProfile;

    /**
     * Creates an instance of BatchAccountUpdateProperties class.
     */
    public BatchAccountUpdateProperties() {
    }

    /**
     * Get the autoStorage property: The properties related to the auto-storage account.
     * 
     * @return the autoStorage value.
     */
    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    /**
     * Set the autoStorage property: The properties related to the auto-storage account.
     * 
     * @param autoStorage the autoStorage value to set.
     * @return the BatchAccountUpdateProperties object itself.
     */
    public BatchAccountUpdateProperties withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    /**
     * Get the encryption property: Configures how customer data is encrypted inside the Batch account. By default,
     * accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used
     * instead.
     * 
     * @return the encryption value.
     */
    public EncryptionProperties encryption() {
        return this.encryption;
    }

    /**
     * Set the encryption property: Configures how customer data is encrypted inside the Batch account. By default,
     * accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used
     * instead.
     * 
     * @param encryption the encryption value to set.
     * @return the BatchAccountUpdateProperties object itself.
     */
    public BatchAccountUpdateProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the allowedAuthenticationModes property: List of allowed authentication modes for the Batch account that can
     * be used to authenticate with the data plane. This does not affect authentication with the control plane.
     * 
     * @return the allowedAuthenticationModes value.
     */
    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    /**
     * Set the allowedAuthenticationModes property: List of allowed authentication modes for the Batch account that can
     * be used to authenticate with the data plane. This does not affect authentication with the control plane.
     * 
     * @param allowedAuthenticationModes the allowedAuthenticationModes value to set.
     * @return the BatchAccountUpdateProperties object itself.
     */
    public BatchAccountUpdateProperties
        withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        this.allowedAuthenticationModes = allowedAuthenticationModes;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: If not specified, the default value is 'enabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: If not specified, the default value is 'enabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the BatchAccountUpdateProperties object itself.
     */
    public BatchAccountUpdateProperties withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the networkProfile property: The network profile only takes effect when publicNetworkAccess is enabled.
     * 
     * @return the networkProfile value.
     */
    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: The network profile only takes effect when publicNetworkAccess is enabled.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the BatchAccountUpdateProperties object itself.
     */
    public BatchAccountUpdateProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoStorage() != null) {
            autoStorage().validate();
        }
        if (encryption() != null) {
            encryption().validate();
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
    }
}
