// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Quotas associated with a Batch region for a particular subscription.
 */
@Immutable
public final class BatchLocationQuotaInner {
    /*
     * The number of Batch accounts that may be created under the subscription in the specified region.
     */
    @JsonProperty(value = "accountQuota", access = JsonProperty.Access.WRITE_ONLY)
    private Integer accountQuota;

    /**
     * Creates an instance of BatchLocationQuotaInner class.
     */
    public BatchLocationQuotaInner() {
    }

    /**
     * Get the accountQuota property: The number of Batch accounts that may be created under the subscription in the
     * specified region.
     * 
     * @return the accountQuota value.
     */
    public Integer accountQuota() {
        return this.accountQuota;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
