// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.batch.models.CertificateBaseProperties;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Certificate properties.
 */
@Fluent
public final class CertificateProperties extends CertificateBaseProperties {
    /*
     * The provisioningState property.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private CertificateProvisioningState provisioningState;

    /*
     * The time at which the certificate entered its current state.
     */
    @JsonProperty(value = "provisioningStateTransitionTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningStateTransitionTime;

    /*
     * The previous provisioned state of the resource
     */
    @JsonProperty(value = "previousProvisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private CertificateProvisioningState previousProvisioningState;

    /*
     * The time at which the certificate entered its previous state.
     */
    @JsonProperty(value = "previousProvisioningStateTransitionTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime previousProvisioningStateTransitionTime;

    /*
     * The public key of the certificate.
     */
    @JsonProperty(value = "publicData", access = JsonProperty.Access.WRITE_ONLY)
    private String publicData;

    /*
     * This is only returned when the certificate provisioningState is 'Failed'.
     */
    @JsonProperty(value = "deleteCertificateError", access = JsonProperty.Access.WRITE_ONLY)
    private DeleteCertificateError deleteCertificateError;

    /**
     * Creates an instance of CertificateProperties class.
     */
    public CertificateProperties() {
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningStateTransitionTime property: The time at which the certificate entered its current state.
     * 
     * @return the provisioningStateTransitionTime value.
     */
    public OffsetDateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    /**
     * Get the previousProvisioningState property: The previous provisioned state of the resource.
     * 
     * @return the previousProvisioningState value.
     */
    public CertificateProvisioningState previousProvisioningState() {
        return this.previousProvisioningState;
    }

    /**
     * Get the previousProvisioningStateTransitionTime property: The time at which the certificate entered its previous
     * state.
     * 
     * @return the previousProvisioningStateTransitionTime value.
     */
    public OffsetDateTime previousProvisioningStateTransitionTime() {
        return this.previousProvisioningStateTransitionTime;
    }

    /**
     * Get the publicData property: The public key of the certificate.
     * 
     * @return the publicData value.
     */
    public String publicData() {
        return this.publicData;
    }

    /**
     * Get the deleteCertificateError property: This is only returned when the certificate provisioningState is
     * 'Failed'.
     * 
     * @return the deleteCertificateError value.
     */
    public DeleteCertificateError deleteCertificateError() {
        return this.deleteCertificateError;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        super.withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateProperties withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateProperties withFormat(CertificateFormat format) {
        super.withFormat(format);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (deleteCertificateError() != null) {
            deleteCertificateError().validate();
        }
    }
}
