// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Contains the information for a detector.
 */
@Fluent
public final class DetectorResponseInner extends ProxyResource {
    /*
     * The properties associated with the detector.
     */
    @JsonProperty(value = "properties")
    private DetectorResponseProperties innerProperties;

    /*
     * The ETag of the resource, used for concurrency statements.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Creates an instance of DetectorResponseInner class.
     */
    public DetectorResponseInner() {
    }

    /**
     * Get the innerProperties property: The properties associated with the detector.
     * 
     * @return the innerProperties value.
     */
    private DetectorResponseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the value property: A base64 encoded string that represents the content of a detector.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: A base64 encoded string that represents the content of a detector.
     * 
     * @param value the value value to set.
     * @return the DetectorResponseInner object itself.
     */
    public DetectorResponseInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DetectorResponseProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
