// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.batch.models.EndpointDependency;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A collection of related endpoints from the same service for which the Batch service requires outbound access.
 */
@Immutable
public final class OutboundEnvironmentEndpointInner {
    /*
     * The type of service that the Batch service connects to.
     */
    @JsonProperty(value = "category", access = JsonProperty.Access.WRITE_ONLY)
    private String category;

    /*
     * The endpoints for this service to which the Batch service makes outbound calls.
     */
    @JsonProperty(value = "endpoints", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointDependency> endpoints;

    /**
     * Creates an instance of OutboundEnvironmentEndpointInner class.
     */
    public OutboundEnvironmentEndpointInner() {
    }

    /**
     * Get the category property: The type of service that the Batch service connects to.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Get the endpoints property: The endpoints for this service to which the Batch service makes outbound calls.
     * 
     * @return the endpoints value.
     */
    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpoints() != null) {
            endpoints().forEach(e -> e.validate());
        }
    }
}
