// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.batch.models.PrivateEndpoint;
import com.azure.resourcemanager.batch.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.batch.models.PrivateLinkServiceConnectionState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Private endpoint connection properties.
 */
@Fluent
public final class PrivateEndpointConnectionProperties {
    /*
     * The provisioning state of the private endpoint connection.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpointConnectionProvisioningState provisioningState;

    /*
     * The private endpoint of the private endpoint connection.
     */
    @JsonProperty(value = "privateEndpoint", access = JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpoint privateEndpoint;

    /*
     * The group id of the private endpoint connection.
     * 
     * The value has one and only one group id.
     */
    @JsonProperty(value = "groupIds", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> groupIds;

    /*
     * The private link service connection state of the private endpoint connection
     */
    @JsonProperty(value = "privateLinkServiceConnectionState")
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;

    /**
     * Creates an instance of PrivateEndpointConnectionProperties class.
     */
    public PrivateEndpointConnectionProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the private endpoint connection.
     * 
     * @return the provisioningState value.
     */
    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateEndpoint property: The private endpoint of the private endpoint connection.
     * 
     * @return the privateEndpoint value.
     */
    public PrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    /**
     * Get the groupIds property: The group id of the private endpoint connection.
     * 
     * The value has one and only one group id.
     * 
     * @return the groupIds value.
     */
    public List<String> groupIds() {
        return this.groupIds;
    }

    /**
     * Get the privateLinkServiceConnectionState property: The private link service connection state of the private
     * endpoint connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    /**
     * Set the privateLinkServiceConnectionState property: The private link service connection state of the private
     * endpoint connection.
     * 
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the PrivateEndpointConnectionProperties object itself.
     */
    public PrivateEndpointConnectionProperties
        withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpoint() != null) {
            privateEndpoint().validate();
        }
        if (privateLinkServiceConnectionState() != null) {
            privateLinkServiceConnectionState().validate();
        }
    }
}
