// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.batch.models.SkuCapability;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Describes a Batch supported SKU.
 */
@Immutable
public final class SupportedSkuInner {
    /*
     * The name of the SKU.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The family name of the SKU.
     */
    @JsonProperty(value = "familyName", access = JsonProperty.Access.WRITE_ONLY)
    private String familyName;

    /*
     * A collection of capabilities which this SKU supports.
     */
    @JsonProperty(value = "capabilities", access = JsonProperty.Access.WRITE_ONLY)
    private List<SkuCapability> capabilities;

    /**
     * Creates an instance of SupportedSkuInner class.
     */
    public SupportedSkuInner() {
    }

    /**
     * Get the name property: The name of the SKU.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the familyName property: The family name of the SKU.
     * 
     * @return the familyName value.
     */
    public String familyName() {
        return this.familyName;
    }

    /**
     * Get the capabilities property: A collection of capabilities which this SKU supports.
     * 
     * @return the capabilities value.
     */
    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
    }
}
