// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.batch.fluent.ApplicationPackagesClient;
import com.azure.resourcemanager.batch.fluent.models.ApplicationPackageInner;
import com.azure.resourcemanager.batch.models.ActivateApplicationPackageParameters;
import com.azure.resourcemanager.batch.models.ListApplicationPackagesResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ApplicationPackagesClient.
 */
public final class ApplicationPackagesClientImpl implements ApplicationPackagesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ApplicationPackagesService service;

    /**
     * The service client containing this operation class.
     */
    private final BatchManagementClientImpl client;

    /**
     * Initializes an instance of ApplicationPackagesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ApplicationPackagesClientImpl(BatchManagementClientImpl client) {
        this.service = RestProxy.create(ApplicationPackagesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for BatchManagementClientApplicationPackages to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "BatchManagementClien")
    public interface ApplicationPackagesService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}/activate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationPackageInner>> activate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("applicationName") String applicationName, @PathParam("versionName") String versionName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ActivateApplicationPackageParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationPackageInner>> create(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("applicationName") String applicationName, @PathParam("versionName") String versionName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ApplicationPackageInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("applicationName") String applicationName, @PathParam("versionName") String versionName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationPackageInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("applicationName") String applicationName, @PathParam("versionName") String versionName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListApplicationPackagesResult>> list(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("applicationName") String applicationName, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListApplicationPackagesResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Activates the specified application package. This should be done after the `ApplicationPackage` was created and
     * uploaded. This needs to be done before an `ApplicationPackage` can be used on Pools or Tasks.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationPackageInner>> activateWithResponseAsync(String resourceGroupName,
        String accountName, String applicationName, String versionName,
        ActivateApplicationPackageParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.activate(this.client.getEndpoint(), resourceGroupName, accountName,
                applicationName, versionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Activates the specified application package. This should be done after the `ApplicationPackage` was created and
     * uploaded. This needs to be done before an `ApplicationPackage` can be used on Pools or Tasks.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationPackageInner>> activateWithResponseAsync(String resourceGroupName,
        String accountName, String applicationName, String versionName, ActivateApplicationPackageParameters parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.activate(this.client.getEndpoint(), resourceGroupName, accountName, applicationName, versionName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Activates the specified application package. This should be done after the `ApplicationPackage` was created and
     * uploaded. This needs to be done before an `ApplicationPackage` can be used on Pools or Tasks.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationPackageInner> activateAsync(String resourceGroupName, String accountName,
        String applicationName, String versionName, ActivateApplicationPackageParameters parameters) {
        return activateWithResponseAsync(resourceGroupName, accountName, applicationName, versionName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Activates the specified application package. This should be done after the `ApplicationPackage` was created and
     * uploaded. This needs to be done before an `ApplicationPackage` can be used on Pools or Tasks.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationPackageInner> activateWithResponse(String resourceGroupName, String accountName,
        String applicationName, String versionName, ActivateApplicationPackageParameters parameters, Context context) {
        return activateWithResponseAsync(resourceGroupName, accountName, applicationName, versionName, parameters,
            context).block();
    }

    /**
     * Activates the specified application package. This should be done after the `ApplicationPackage` was created and
     * uploaded. This needs to be done before an `ApplicationPackage` can be used on Pools or Tasks.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationPackageInner activate(String resourceGroupName, String accountName, String applicationName,
        String versionName, ActivateApplicationPackageParameters parameters) {
        return activateWithResponse(resourceGroupName, accountName, applicationName, versionName, parameters,
            Context.NONE).getValue();
    }

    /**
     * Creates an application package record. The record contains a storageUrl where the package should be uploaded to.
     * Once it is uploaded the `ApplicationPackage` needs to be activated using `ApplicationPackageActive` before it can
     * be used. If the auto storage account was configured to use storage keys, the URL returned will contain a SAS.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationPackageInner>> createWithResponseAsync(String resourceGroupName,
        String accountName, String applicationName, String versionName, ApplicationPackageInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), resourceGroupName, accountName,
                applicationName, versionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates an application package record. The record contains a storageUrl where the package should be uploaded to.
     * Once it is uploaded the `ApplicationPackage` needs to be activated using `ApplicationPackageActive` before it can
     * be used. If the auto storage account was configured to use storage keys, the URL returned will contain a SAS.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationPackageInner>> createWithResponseAsync(String resourceGroupName,
        String accountName, String applicationName, String versionName, ApplicationPackageInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), resourceGroupName, accountName, applicationName, versionName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Creates an application package record. The record contains a storageUrl where the package should be uploaded to.
     * Once it is uploaded the `ApplicationPackage` needs to be activated using `ApplicationPackageActive` before it can
     * be used. If the auto storage account was configured to use storage keys, the URL returned will contain a SAS.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationPackageInner> createAsync(String resourceGroupName, String accountName,
        String applicationName, String versionName) {
        final ApplicationPackageInner parameters = null;
        return createWithResponseAsync(resourceGroupName, accountName, applicationName, versionName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates an application package record. The record contains a storageUrl where the package should be uploaded to.
     * Once it is uploaded the `ApplicationPackage` needs to be activated using `ApplicationPackageActive` before it can
     * be used. If the auto storage account was configured to use storage keys, the URL returned will contain a SAS.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param parameters The parameters for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationPackageInner> createWithResponse(String resourceGroupName, String accountName,
        String applicationName, String versionName, ApplicationPackageInner parameters, Context context) {
        return createWithResponseAsync(resourceGroupName, accountName, applicationName, versionName, parameters,
            context).block();
    }

    /**
     * Creates an application package record. The record contains a storageUrl where the package should be uploaded to.
     * Once it is uploaded the `ApplicationPackage` needs to be activated using `ApplicationPackageActive` before it can
     * be used. If the auto storage account was configured to use storage keys, the URL returned will contain a SAS.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application package which represents a particular version of an application.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationPackageInner create(String resourceGroupName, String accountName, String applicationName,
        String versionName) {
        final ApplicationPackageInner parameters = null;
        return createWithResponse(resourceGroupName, accountName, applicationName, versionName, parameters,
            Context.NONE).getValue();
    }

    /**
     * Deletes an application package record and its associated binary file.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName,
        String applicationName, String versionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), resourceGroupName, accountName, applicationName,
                    versionName, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an application package record and its associated binary file.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName,
        String applicationName, String versionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, accountName, applicationName, versionName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes an application package record and its associated binary file.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, String applicationName,
        String versionName) {
        return deleteWithResponseAsync(resourceGroupName, accountName, applicationName, versionName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an application package record and its associated binary file.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String applicationName,
        String versionName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, accountName, applicationName, versionName, context).block();
    }

    /**
     * Deletes an application package record and its associated binary file.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String applicationName, String versionName) {
        deleteWithResponse(resourceGroupName, accountName, applicationName, versionName, Context.NONE);
    }

    /**
     * Gets information about the specified application package.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified application package along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationPackageInner>> getWithResponseAsync(String resourceGroupName, String accountName,
        String applicationName, String versionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), resourceGroupName, accountName, applicationName,
                    versionName, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets information about the specified application package.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified application package along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationPackageInner>> getWithResponseAsync(String resourceGroupName, String accountName,
        String applicationName, String versionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, accountName, applicationName, versionName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets information about the specified application package.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified application package on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationPackageInner> getAsync(String resourceGroupName, String accountName, String applicationName,
        String versionName) {
        return getWithResponseAsync(resourceGroupName, accountName, applicationName, versionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets information about the specified application package.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified application package along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationPackageInner> getWithResponse(String resourceGroupName, String accountName,
        String applicationName, String versionName, Context context) {
        return getWithResponseAsync(resourceGroupName, accountName, applicationName, versionName, context).block();
    }

    /**
     * Gets information about the specified application package.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param versionName The version of the application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about the specified application package.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationPackageInner get(String resourceGroupName, String accountName, String applicationName,
        String versionName) {
        return getWithResponse(resourceGroupName, accountName, applicationName, versionName, Context.NONE).getValue();
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationPackageInner>> listSinglePageAsync(String resourceGroupName,
        String accountName, String applicationName, Integer maxresults) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.list(this.client.getEndpoint(), resourceGroupName, accountName, applicationName,
                    maxresults, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ApplicationPackageInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param maxresults The maximum number of items to return in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationPackageInner>> listSinglePageAsync(String resourceGroupName,
        String accountName, String applicationName, Integer maxresults, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (applicationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter applicationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), resourceGroupName, accountName, applicationName, maxresults,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApplicationPackageInner> listAsync(String resourceGroupName, String accountName,
        String applicationName, Integer maxresults) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, accountName, applicationName, maxresults),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApplicationPackageInner> listAsync(String resourceGroupName, String accountName,
        String applicationName) {
        final Integer maxresults = null;
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, accountName, applicationName, maxresults),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param maxresults The maximum number of items to return in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApplicationPackageInner> listAsync(String resourceGroupName, String accountName,
        String applicationName, Integer maxresults, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, accountName, applicationName, maxresults, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApplicationPackageInner> list(String resourceGroupName, String accountName,
        String applicationName) {
        final Integer maxresults = null;
        return new PagedIterable<>(listAsync(resourceGroupName, accountName, applicationName, maxresults));
    }

    /**
     * Lists all of the application packages in the specified application.
     * 
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param maxresults The maximum number of items to return in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApplicationPackageInner> list(String resourceGroupName, String accountName,
        String applicationName, Integer maxresults, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, accountName, applicationName, maxresults, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationPackageInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ApplicationPackageInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of performing list application packages along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationPackageInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
