// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.fluent.PoolsClient;
import com.azure.resourcemanager.batch.fluent.models.PoolInner;
import com.azure.resourcemanager.batch.models.Pool;
import com.azure.resourcemanager.batch.models.Pools;
import com.azure.resourcemanager.batch.models.PoolsDisableAutoScaleResponse;
import com.azure.resourcemanager.batch.models.PoolsGetResponse;
import com.azure.resourcemanager.batch.models.PoolsStopResizeResponse;

public final class PoolsImpl implements Pools {
    private static final ClientLogger LOGGER = new ClientLogger(PoolsImpl.class);

    private final PoolsClient innerClient;

    private final com.azure.resourcemanager.batch.BatchManager serviceManager;

    public PoolsImpl(PoolsClient innerClient, com.azure.resourcemanager.batch.BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<Pool> listByBatchAccount(String resourceGroupName, String accountName) {
        PagedIterable<PoolInner> inner = this.serviceClient().listByBatchAccount(resourceGroupName, accountName);
        return Utils.mapPage(inner, inner1 -> new PoolImpl(inner1, this.manager()));
    }

    public PagedIterable<Pool> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults,
        String select, String filter, Context context) {
        PagedIterable<PoolInner> inner = this.serviceClient().listByBatchAccount(resourceGroupName, accountName,
            maxresults, select, filter, context);
        return Utils.mapPage(inner, inner1 -> new PoolImpl(inner1, this.manager()));
    }

    public void delete(String resourceGroupName, String accountName, String poolName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName);
    }

    public void delete(String resourceGroupName, String accountName, String poolName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, context);
    }

    public Response<Pool> getWithResponse(String resourceGroupName, String accountName, String poolName,
        Context context) {
        PoolsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PoolImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Pool get(String resourceGroupName, String accountName, String poolName) {
        PoolInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new PoolImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Pool> disableAutoScaleWithResponse(String resourceGroupName, String accountName, String poolName,
        Context context) {
        PoolsDisableAutoScaleResponse inner
            = this.serviceClient().disableAutoScaleWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PoolImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Pool disableAutoScale(String resourceGroupName, String accountName, String poolName) {
        PoolInner inner = this.serviceClient().disableAutoScale(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new PoolImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Pool> stopResizeWithResponse(String resourceGroupName, String accountName, String poolName,
        Context context) {
        PoolsStopResizeResponse inner
            = this.serviceClient().stopResizeWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PoolImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Pool stopResize(String resourceGroupName, String accountName, String poolName) {
        PoolInner inner = this.serviceClient().stopResize(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new PoolImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Pool getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = Utils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, Context.NONE).getValue();
    }

    public Response<Pool> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = Utils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = Utils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String poolName = Utils.getValueFromIdByName(id, "pools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'pools'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, context);
    }

    private PoolsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.batch.BatchManager manager() {
        return this.serviceManager;
    }

    public PoolImpl define(String name) {
        return new PoolImpl(name, this.manager());
    }
}
