// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for an activating an application package.
 */
@Fluent
public final class ActivateApplicationPackageParameters {
    /*
     * The format of the application package binary file.
     */
    @JsonProperty(value = "format", required = true)
    private String format;

    /**
     * Creates an instance of ActivateApplicationPackageParameters class.
     */
    public ActivateApplicationPackageParameters() {
    }

    /**
     * Get the format property: The format of the application package binary file.
     * 
     * @return the format value.
     */
    public String format() {
        return this.format;
    }

    /**
     * Set the format property: The format of the application package binary file.
     * 
     * @param format the format value to set.
     * @return the ActivateApplicationPackageParameters object itself.
     */
    public ActivateApplicationPackageParameters withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (format() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property format in model ActivateApplicationPackageParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ActivateApplicationPackageParameters.class);
}
