// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The authentication mode for the Batch account.
 */
public enum AuthenticationMode {
    /**
     * Enum value SharedKey.
     */
    SHARED_KEY("SharedKey"),

    /**
     * Enum value AAD.
     */
    AAD("AAD"),

    /**
     * Enum value TaskAuthenticationToken.
     */
    TASK_AUTHENTICATION_TOKEN("TaskAuthenticationToken");

    /**
     * The actual serialized value for a AuthenticationMode instance.
     */
    private final String value;

    AuthenticationMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AuthenticationMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AuthenticationMode object, or null if unable to parse.
     */
    @JsonCreator
    public static AuthenticationMode fromString(String value) {
        if (value == null) {
            return null;
        }
        AuthenticationMode[] items = AuthenticationMode.values();
        for (AuthenticationMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
