// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties related to the auto-storage account.
 */
@Fluent
public class AutoStorageBaseProperties {
    /*
     * The resource ID of the storage account to be used for auto-storage account.
     */
    @JsonProperty(value = "storageAccountId", required = true)
    private String storageAccountId;

    /*
     * The authentication mode which the Batch service will use to manage the auto-storage account.
     */
    @JsonProperty(value = "authenticationMode")
    private AutoStorageAuthenticationMode authenticationMode;

    /*
     * The identity referenced here must be assigned to pools which have compute nodes that need access to
     * auto-storage.
     */
    @JsonProperty(value = "nodeIdentityReference")
    private ComputeNodeIdentityReference nodeIdentityReference;

    /**
     * Creates an instance of AutoStorageBaseProperties class.
     */
    public AutoStorageBaseProperties() {
    }

    /**
     * Get the storageAccountId property: The resource ID of the storage account to be used for auto-storage account.
     * 
     * @return the storageAccountId value.
     */
    public String storageAccountId() {
        return this.storageAccountId;
    }

    /**
     * Set the storageAccountId property: The resource ID of the storage account to be used for auto-storage account.
     * 
     * @param storageAccountId the storageAccountId value to set.
     * @return the AutoStorageBaseProperties object itself.
     */
    public AutoStorageBaseProperties withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    /**
     * Get the authenticationMode property: The authentication mode which the Batch service will use to manage the
     * auto-storage account.
     * 
     * @return the authenticationMode value.
     */
    public AutoStorageAuthenticationMode authenticationMode() {
        return this.authenticationMode;
    }

    /**
     * Set the authenticationMode property: The authentication mode which the Batch service will use to manage the
     * auto-storage account.
     * 
     * @param authenticationMode the authenticationMode value to set.
     * @return the AutoStorageBaseProperties object itself.
     */
    public AutoStorageBaseProperties withAuthenticationMode(AutoStorageAuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
        return this;
    }

    /**
     * Get the nodeIdentityReference property: The identity referenced here must be assigned to pools which have
     * compute nodes that need access to auto-storage.
     * 
     * @return the nodeIdentityReference value.
     */
    public ComputeNodeIdentityReference nodeIdentityReference() {
        return this.nodeIdentityReference;
    }

    /**
     * Set the nodeIdentityReference property: The identity referenced here must be assigned to pools which have
     * compute nodes that need access to auto-storage.
     * 
     * @param nodeIdentityReference the nodeIdentityReference value to set.
     * @return the AutoStorageBaseProperties object itself.
     */
    public AutoStorageBaseProperties withNodeIdentityReference(ComputeNodeIdentityReference nodeIdentityReference) {
        this.nodeIdentityReference = nodeIdentityReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccountId() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property storageAccountId in model AutoStorageBaseProperties"));
        }
        if (nodeIdentityReference() != null) {
            nodeIdentityReference().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoStorageBaseProperties.class);
}
