// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters supplied to the RegenerateKey operation.
 */
@Fluent
public final class BatchAccountRegenerateKeyParameters {
    /*
     * The type of account key to regenerate.
     */
    @JsonProperty(value = "keyName", required = true)
    private AccountKeyType keyName;

    /**
     * Creates an instance of BatchAccountRegenerateKeyParameters class.
     */
    public BatchAccountRegenerateKeyParameters() {
    }

    /**
     * Get the keyName property: The type of account key to regenerate.
     * 
     * @return the keyName value.
     */
    public AccountKeyType keyName() {
        return this.keyName;
    }

    /**
     * Set the keyName property: The type of account key to regenerate.
     * 
     * @param keyName the keyName value to set.
     * @return the BatchAccountRegenerateKeyParameters object itself.
     */
    public BatchAccountRegenerateKeyParameters withKeyName(AccountKeyType keyName) {
        this.keyName = keyName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyName() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property keyName in model BatchAccountRegenerateKeyParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BatchAccountRegenerateKeyParameters.class);
}
