// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of caching to enable for the disk.
 */
public enum CachingType {
    /**
     * Enum value None.
     */
    NONE("None"),

    /**
     * Enum value ReadOnly.
     */
    READ_ONLY("ReadOnly"),

    /**
     * Enum value ReadWrite.
     */
    READ_WRITE("ReadWrite");

    /**
     * The actual serialized value for a CachingType instance.
     */
    private final String value;

    CachingType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CachingType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CachingType object, or null if unable to parse.
     */
    @JsonCreator
    public static CachingType fromString(String value) {
        if (value == null) {
            return null;
        }
        CachingType[] items = CachingType.values();
        for (CachingType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
