// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.fluent.models.CertificateInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of Certificate.
 */
public interface Certificate {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    CertificateProvisioningState provisioningState();

    /**
     * Gets the provisioningStateTransitionTime property: The time at which the certificate entered its current state.
     * 
     * @return the provisioningStateTransitionTime value.
     */
    OffsetDateTime provisioningStateTransitionTime();

    /**
     * Gets the previousProvisioningState property: The previous provisioned state of the resource.
     * 
     * @return the previousProvisioningState value.
     */
    CertificateProvisioningState previousProvisioningState();

    /**
     * Gets the previousProvisioningStateTransitionTime property: The time at which the certificate entered its previous
     * state.
     * 
     * @return the previousProvisioningStateTransitionTime value.
     */
    OffsetDateTime previousProvisioningStateTransitionTime();

    /**
     * Gets the publicData property: The public key of the certificate.
     * 
     * @return the publicData value.
     */
    String publicData();

    /**
     * Gets the deleteCertificateError property: This is only returned when the certificate provisioningState is
     * 'Failed'.
     * 
     * @return the deleteCertificateError value.
     */
    DeleteCertificateError deleteCertificateError();

    /**
     * Gets the thumbprintAlgorithm property: The algorithm of the certificate thumbprint.
     * 
     * This must match the first portion of the certificate name. Currently required to be 'SHA1'.
     * 
     * @return the thumbprintAlgorithm value.
     */
    String thumbprintAlgorithm();

    /**
     * Gets the thumbprint property: The thumbprint of the certificate.
     * 
     * This must match the thumbprint from the name.
     * 
     * @return the thumbprint value.
     */
    String thumbprint();

    /**
     * Gets the format property: The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
     * 
     * @return the format value.
     */
    CertificateFormat format();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.batch.fluent.models.CertificateInner object.
     * 
     * @return the inner object.
     */
    CertificateInner innerModel();

    /**
     * The entirety of the Certificate definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The Certificate definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the Certificate definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the Certificate definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, accountName.
             * 
             * @param resourceGroupName The name of the resource group that contains the Batch account.
             * @param accountName The name of the Batch account.
             * @return the next definition stage.
             */
            WithCreate withExistingBatchAccount(String resourceGroupName, String accountName);
        }

        /**
         * The stage of the Certificate definition which contains all the minimum required properties for the resource
         * to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithPassword, DefinitionStages.WithThumbprintAlgorithm,
            DefinitionStages.WithThumbprint, DefinitionStages.WithFormat, DefinitionStages.WithIfMatch,
            DefinitionStages.WithIfNoneMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            Certificate create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            Certificate create(Context context);
        }

        /**
         * The stage of the Certificate definition allowing to specify password.
         */
        interface WithPassword {
            /**
             * Specifies the password property: The password to access the certificate's private key.
             * 
             * This must not be specified if the certificate format is Cer..
             * 
             * @param password The password to access the certificate's private key.
             * 
             * This must not be specified if the certificate format is Cer.
             * @return the next definition stage.
             */
            WithCreate withPassword(String password);
        }

        /**
         * The stage of the Certificate definition allowing to specify thumbprintAlgorithm.
         */
        interface WithThumbprintAlgorithm {
            /**
             * Specifies the thumbprintAlgorithm property: The algorithm of the certificate thumbprint.
             * 
             * This must match the first portion of the certificate name. Currently required to be 'SHA1'..
             * 
             * @param thumbprintAlgorithm The algorithm of the certificate thumbprint.
             * 
             * This must match the first portion of the certificate name. Currently required to be 'SHA1'.
             * @return the next definition stage.
             */
            WithCreate withThumbprintAlgorithm(String thumbprintAlgorithm);
        }

        /**
         * The stage of the Certificate definition allowing to specify thumbprint.
         */
        interface WithThumbprint {
            /**
             * Specifies the thumbprint property: The thumbprint of the certificate.
             * 
             * This must match the thumbprint from the name..
             * 
             * @param thumbprint The thumbprint of the certificate.
             * 
             * This must match the thumbprint from the name.
             * @return the next definition stage.
             */
            WithCreate withThumbprint(String thumbprint);
        }

        /**
         * The stage of the Certificate definition allowing to specify format.
         */
        interface WithFormat {
            /**
             * Specifies the format property: The format of the certificate - either Pfx or Cer. If omitted, the default
             * is Pfx..
             * 
             * @param format The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
             * @return the next definition stage.
             */
            WithCreate withFormat(CertificateFormat format);
        }

        /**
         * The stage of the Certificate definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: The entity state (ETag) version of the certificate to update. A value of
             * "*" can be used to apply the operation only if the certificate already exists. If omitted, this operation
             * will always be applied..
             * 
             * @param ifMatch The entity state (ETag) version of the certificate to update. A value of "*" can be used
             * to apply the operation only if the certificate already exists. If omitted, this operation will always be
             * applied.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }

        /**
         * The stage of the Certificate definition allowing to specify ifNoneMatch.
         */
        interface WithIfNoneMatch {
            /**
             * Specifies the ifNoneMatch property: Set to '*' to allow a new certificate to be created, but to prevent
             * updating an existing certificate. Other values will be ignored..
             * 
             * @param ifNoneMatch Set to '*' to allow a new certificate to be created, but to prevent updating an
             * existing certificate. Other values will be ignored.
             * @return the next definition stage.
             */
            WithCreate withIfNoneMatch(String ifNoneMatch);
        }
    }

    /**
     * Begins update for the Certificate resource.
     * 
     * @return the stage of resource update.
     */
    Certificate.Update update();

    /**
     * The template for Certificate update.
     */
    interface Update extends UpdateStages.WithData, UpdateStages.WithPassword, UpdateStages.WithThumbprintAlgorithm,
        UpdateStages.WithThumbprint, UpdateStages.WithFormat, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        Certificate apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        Certificate apply(Context context);
    }

    /**
     * The Certificate update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the Certificate update allowing to specify data.
         */
        interface WithData {
            /**
             * Specifies the data property: The base64-encoded contents of the certificate.
             * 
             * The maximum size is 10KB..
             * 
             * @param data The base64-encoded contents of the certificate.
             * 
             * The maximum size is 10KB.
             * @return the next definition stage.
             */
            Update withData(String data);
        }

        /**
         * The stage of the Certificate update allowing to specify password.
         */
        interface WithPassword {
            /**
             * Specifies the password property: The password to access the certificate's private key.
             * 
             * This must not be specified if the certificate format is Cer..
             * 
             * @param password The password to access the certificate's private key.
             * 
             * This must not be specified if the certificate format is Cer.
             * @return the next definition stage.
             */
            Update withPassword(String password);
        }

        /**
         * The stage of the Certificate update allowing to specify thumbprintAlgorithm.
         */
        interface WithThumbprintAlgorithm {
            /**
             * Specifies the thumbprintAlgorithm property: The algorithm of the certificate thumbprint.
             * 
             * This must match the first portion of the certificate name. Currently required to be 'SHA1'..
             * 
             * @param thumbprintAlgorithm The algorithm of the certificate thumbprint.
             * 
             * This must match the first portion of the certificate name. Currently required to be 'SHA1'.
             * @return the next definition stage.
             */
            Update withThumbprintAlgorithm(String thumbprintAlgorithm);
        }

        /**
         * The stage of the Certificate update allowing to specify thumbprint.
         */
        interface WithThumbprint {
            /**
             * Specifies the thumbprint property: The thumbprint of the certificate.
             * 
             * This must match the thumbprint from the name..
             * 
             * @param thumbprint The thumbprint of the certificate.
             * 
             * This must match the thumbprint from the name.
             * @return the next definition stage.
             */
            Update withThumbprint(String thumbprint);
        }

        /**
         * The stage of the Certificate update allowing to specify format.
         */
        interface WithFormat {
            /**
             * Specifies the format property: The format of the certificate - either Pfx or Cer. If omitted, the default
             * is Pfx..
             * 
             * @param format The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
             * @return the next definition stage.
             */
            Update withFormat(CertificateFormat format);
        }

        /**
         * The stage of the Certificate update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: The entity state (ETag) version of the certificate to update. This value
             * can be omitted or set to "*" to apply the operation unconditionally..
             * 
             * @param ifMatch The entity state (ETag) version of the certificate to update. This value can be omitted or
             * set to "*" to apply the operation unconditionally.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    Certificate refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    Certificate refresh(Context context);

    /**
     * Cancels a failed deletion of a certificate from the specified account.
     * 
     * If you try to delete a certificate that is being used by a pool or compute node, the status of the certificate
     * changes to deleteFailed. If you decide that you want to continue using the certificate, you can use this
     * operation to set the status of the certificate back to active. If you intend to delete the certificate, you do
     * not need to run this operation after the deletion failed. You must make sure that the certificate is not being
     * used by any resources, and then you can try again to delete the certificate.
     * 
     * Warning: This operation is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault
     * Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return contains information about a certificate.
     */
    Response<Certificate> cancelDeletionWithResponse(Context context);

    /**
     * Cancels a failed deletion of a certificate from the specified account.
     * 
     * If you try to delete a certificate that is being used by a pool or compute node, the status of the certificate
     * changes to deleteFailed. If you decide that you want to continue using the certificate, you can use this
     * operation to set the status of the certificate back to active. If you intend to delete the certificate, you do
     * not need to run this operation after the deletion failed. You must make sure that the certificate is not being
     * used by any resources, and then you can try again to delete the certificate.
     * 
     * Warning: This operation is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault
     * Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return contains information about a certificate.
     */
    Certificate cancelDeletion();
}
