// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.batch.fluent.models.CertificateCreateOrUpdateProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Contains information about a certificate.
 */
@Fluent
public final class CertificateCreateOrUpdateParameters extends ProxyResource {
    /*
     * The properties associated with the certificate.
     */
    @JsonProperty(value = "properties")
    private CertificateCreateOrUpdateProperties innerProperties;

    /*
     * The ETag of the resource, used for concurrency statements.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Creates an instance of CertificateCreateOrUpdateParameters class.
     */
    public CertificateCreateOrUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The properties associated with the certificate.
     * 
     * @return the innerProperties value.
     */
    private CertificateCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the data property: The base64-encoded contents of the certificate.
     * 
     * The maximum size is 10KB.
     * 
     * @return the data value.
     */
    public String data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    /**
     * Set the data property: The base64-encoded contents of the certificate.
     * 
     * The maximum size is 10KB.
     * 
     * @param data the data value to set.
     * @return the CertificateCreateOrUpdateParameters object itself.
     */
    public CertificateCreateOrUpdateParameters withData(String data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withData(data);
        return this;
    }

    /**
     * Get the password property: The password to access the certificate's private key.
     * 
     * This must not be specified if the certificate format is Cer.
     * 
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: The password to access the certificate's private key.
     * 
     * This must not be specified if the certificate format is Cer.
     * 
     * @param password the password value to set.
     * @return the CertificateCreateOrUpdateParameters object itself.
     */
    public CertificateCreateOrUpdateParameters withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the thumbprintAlgorithm property: The algorithm of the certificate thumbprint.
     * 
     * This must match the first portion of the certificate name. Currently required to be 'SHA1'.
     * 
     * @return the thumbprintAlgorithm value.
     */
    public String thumbprintAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprintAlgorithm();
    }

    /**
     * Set the thumbprintAlgorithm property: The algorithm of the certificate thumbprint.
     * 
     * This must match the first portion of the certificate name. Currently required to be 'SHA1'.
     * 
     * @param thumbprintAlgorithm the thumbprintAlgorithm value to set.
     * @return the CertificateCreateOrUpdateParameters object itself.
     */
    public CertificateCreateOrUpdateParameters withThumbprintAlgorithm(String thumbprintAlgorithm) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    /**
     * Get the thumbprint property: The thumbprint of the certificate.
     * 
     * This must match the thumbprint from the name.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    /**
     * Set the thumbprint property: The thumbprint of the certificate.
     * 
     * This must match the thumbprint from the name.
     * 
     * @param thumbprint the thumbprint value to set.
     * @return the CertificateCreateOrUpdateParameters object itself.
     */
    public CertificateCreateOrUpdateParameters withThumbprint(String thumbprint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withThumbprint(thumbprint);
        return this;
    }

    /**
     * Get the format property: The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
     * 
     * @return the format value.
     */
    public CertificateFormat format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    /**
     * Set the format property: The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
     * 
     * @param format the format value to set.
     * @return the CertificateCreateOrUpdateParameters object itself.
     */
    public CertificateCreateOrUpdateParameters withFormat(CertificateFormat format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
