// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for CertificateProvisioningState.
 */
public enum CertificateProvisioningState {
    /**
     * Enum value Succeeded.
     */
    SUCCEEDED("Succeeded"),

    /**
     * Enum value Deleting.
     */
    DELETING("Deleting"),

    /**
     * Enum value Failed.
     */
    FAILED("Failed");

    /**
     * The actual serialized value for a CertificateProvisioningState instance.
     */
    private final String value;

    CertificateProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CertificateProvisioningState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CertificateProvisioningState object, or null if unable to parse.
     */
    @JsonCreator
    public static CertificateProvisioningState fromString(String value) {
        if (value == null) {
            return null;
        }
        CertificateProvisioningState[] items = CertificateProvisioningState.values();
        for (CertificateProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
