// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 */
@Fluent
public final class ComputeNodeIdentityReference {
    /*
     * The ARM resource id of the user assigned identity.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /**
     * Creates an instance of ComputeNodeIdentityReference class.
     */
    public ComputeNodeIdentityReference() {
    }

    /**
     * Get the resourceId property: The ARM resource id of the user assigned identity.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The ARM resource id of the user assigned identity.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ComputeNodeIdentityReference object itself.
     */
    public ComputeNodeIdentityReference withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
