// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A private container registry.
 */
@Fluent
public final class ContainerRegistry {
    /*
     * The user name to log into the registry server.
     */
    @JsonProperty(value = "username")
    private String username;

    /*
     * The password to log into the registry server.
     */
    @JsonProperty(value = "password")
    private String password;

    /*
     * The registry URL.
     * 
     * If omitted, the default is "docker.io".
     */
    @JsonProperty(value = "registryServer")
    private String registryServer;

    /*
     * The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JsonProperty(value = "identityReference")
    private ComputeNodeIdentityReference identityReference;

    /**
     * Creates an instance of ContainerRegistry class.
     */
    public ContainerRegistry() {
    }

    /**
     * Get the username property: The user name to log into the registry server.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The user name to log into the registry server.
     * 
     * @param username the username value to set.
     * @return the ContainerRegistry object itself.
     */
    public ContainerRegistry withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password to log into the registry server.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password to log into the registry server.
     * 
     * @param password the password value to set.
     * @return the ContainerRegistry object itself.
     */
    public ContainerRegistry withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the registryServer property: The registry URL.
     * 
     * If omitted, the default is "docker.io".
     * 
     * @return the registryServer value.
     */
    public String registryServer() {
        return this.registryServer;
    }

    /**
     * Set the registryServer property: The registry URL.
     * 
     * If omitted, the default is "docker.io".
     * 
     * @param registryServer the registryServer value to set.
     * @return the ContainerRegistry object itself.
     */
    public ContainerRegistry withRegistryServer(String registryServer) {
        this.registryServer = registryServer;
        return this;
    }

    /**
     * Get the identityReference property: The reference to a user assigned identity associated with the Batch pool
     * which a compute node will use.
     * 
     * @return the identityReference value.
     */
    public ComputeNodeIdentityReference identityReference() {
        return this.identityReference;
    }

    /**
     * Set the identityReference property: The reference to a user assigned identity associated with the Batch pool
     * which a compute node will use.
     * 
     * @param identityReference the identityReference value to set.
     * @return the ContainerRegistry object itself.
     */
    public ContainerRegistry withIdentityReference(ComputeNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identityReference() != null) {
            identityReference().validate();
        }
    }
}
