// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The container technology to be used.
 */
public final class ContainerType extends ExpandableStringEnum<ContainerType> {
    /**
     * Static value DockerCompatible for ContainerType.
     */
    public static final ContainerType DOCKER_COMPATIBLE = fromString("DockerCompatible");

    /**
     * Static value CriCompatible for ContainerType.
     */
    public static final ContainerType CRI_COMPATIBLE = fromString("CriCompatible");

    /**
     * Creates a new instance of ContainerType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerType() {
    }

    /**
     * Creates or finds a ContainerType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContainerType.
     */
    @JsonCreator
    public static ContainerType fromString(String name) {
        return fromString(name, ContainerType.class);
    }

    /**
     * Gets known ContainerType values.
     * 
     * @return known ContainerType values.
     */
    public static Collection<ContainerType> values() {
        return values(ContainerType.class);
    }
}
