// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A flag to indicate where the container task working directory is. The default is 'taskWorkingDirectory'.
 */
public enum ContainerWorkingDirectory {
    /**
     * Enum value TaskWorkingDirectory.
     */
    TASK_WORKING_DIRECTORY("TaskWorkingDirectory"),

    /**
     * Enum value ContainerImageDefault.
     */
    CONTAINER_IMAGE_DEFAULT("ContainerImageDefault");

    /**
     * The actual serialized value for a ContainerWorkingDirectory instance.
     */
    private final String value;

    ContainerWorkingDirectory(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ContainerWorkingDirectory instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ContainerWorkingDirectory object, or null if unable to parse.
     */
    @JsonCreator
    public static ContainerWorkingDirectory fromString(String value) {
        if (value == null) {
            return null;
        }
        ContainerWorkingDirectory[] items = ContainerWorkingDirectory.values();
        for (ContainerWorkingDirectory item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
