// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data
 * disks, you need to mount and format the disks from within a VM to use them.
 */
@Fluent
public final class DataDisk {
    /*
     * The logical unit number.
     * 
     * The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct
     * lun. The value must be between 0 and 63, inclusive.
     */
    @JsonProperty(value = "lun", required = true)
    private int lun;

    /*
     * The type of caching to enable for the disk.
     * 
     * Values are:
     * 
     * none - The caching mode for the disk is not enabled.
     * readOnly - The caching mode for the disk is read only.
     * readWrite - The caching mode for the disk is read and write.
     * 
     * The default value for caching is none. For information about the caching options see:
     * https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     */
    @JsonProperty(value = "caching")
    private CachingType caching;

    /*
     * The initial disk size in GB when creating new data disk.
     */
    @JsonProperty(value = "diskSizeGB", required = true)
    private int diskSizeGB;

    /*
     * The storage account type for use in creating data disks or OS disk.
     * 
     * If omitted, the default is "Standard_LRS". Values are:
     * 
     * Standard_LRS - The data disk should use standard locally redundant storage.
     * Premium_LRS - The data disk should use premium locally redundant storage.
     */
    @JsonProperty(value = "storageAccountType")
    private StorageAccountType storageAccountType;

    /**
     * Creates an instance of DataDisk class.
     */
    public DataDisk() {
    }

    /**
     * Get the lun property: The logical unit number.
     * 
     * The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct
     * lun. The value must be between 0 and 63, inclusive.
     * 
     * @return the lun value.
     */
    public int lun() {
        return this.lun;
    }

    /**
     * Set the lun property: The logical unit number.
     * 
     * The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct
     * lun. The value must be between 0 and 63, inclusive.
     * 
     * @param lun the lun value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Get the caching property: The type of caching to enable for the disk.
     * 
     * Values are:
     * 
     * none - The caching mode for the disk is not enabled.
     * readOnly - The caching mode for the disk is read only.
     * readWrite - The caching mode for the disk is read and write.
     * 
     * The default value for caching is none. For information about the caching options see:
     * https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     * 
     * @return the caching value.
     */
    public CachingType caching() {
        return this.caching;
    }

    /**
     * Set the caching property: The type of caching to enable for the disk.
     * 
     * Values are:
     * 
     * none - The caching mode for the disk is not enabled.
     * readOnly - The caching mode for the disk is read only.
     * readWrite - The caching mode for the disk is read and write.
     * 
     * The default value for caching is none. For information about the caching options see:
     * https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     * 
     * @param caching the caching value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the diskSizeGB property: The initial disk size in GB when creating new data disk.
     * 
     * @return the diskSizeGB value.
     */
    public int diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: The initial disk size in GB when creating new data disk.
     * 
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withDiskSizeGB(int diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the storageAccountType property: The storage account type for use in creating data disks or OS disk.
     * 
     * If omitted, the default is "Standard_LRS". Values are:
     * 
     * Standard_LRS - The data disk should use standard locally redundant storage.
     * Premium_LRS - The data disk should use premium locally redundant storage.
     * 
     * @return the storageAccountType value.
     */
    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    /**
     * Set the storageAccountType property: The storage account type for use in creating data disks or OS disk.
     * 
     * If omitted, the default is "Standard_LRS". Values are:
     * 
     * Standard_LRS - The data disk should use standard locally redundant storage.
     * Premium_LRS - The data disk should use premium locally redundant storage.
     * 
     * @param storageAccountType the storageAccountType value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
