// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Deployment configuration properties.
 */
@Fluent
public final class DeploymentConfiguration {
    /*
     * The configuration for nodes in a pool based on the Azure Cloud Services platform.
     * 
     * This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be
     * specified. This property cannot be specified if the Batch account was created with its poolAllocationMode
     * property set to 'UserSubscription'.
     */
    @JsonProperty(value = "cloudServiceConfiguration")
    private CloudServiceConfiguration cloudServiceConfiguration;

    /*
     * The configuration for compute nodes in a pool based on the Azure Virtual Machines infrastructure.
     * 
     * This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
     */
    @JsonProperty(value = "virtualMachineConfiguration")
    private VirtualMachineConfiguration virtualMachineConfiguration;

    /**
     * Creates an instance of DeploymentConfiguration class.
     */
    public DeploymentConfiguration() {
    }

    /**
     * Get the cloudServiceConfiguration property: The configuration for nodes in a pool based on the Azure Cloud
     * Services platform.
     * 
     * This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be
     * specified. This property cannot be specified if the Batch account was created with its poolAllocationMode
     * property set to 'UserSubscription'.
     * 
     * @return the cloudServiceConfiguration value.
     */
    public CloudServiceConfiguration cloudServiceConfiguration() {
        return this.cloudServiceConfiguration;
    }

    /**
     * Set the cloudServiceConfiguration property: The configuration for nodes in a pool based on the Azure Cloud
     * Services platform.
     * 
     * This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be
     * specified. This property cannot be specified if the Batch account was created with its poolAllocationMode
     * property set to 'UserSubscription'.
     * 
     * @param cloudServiceConfiguration the cloudServiceConfiguration value to set.
     * @return the DeploymentConfiguration object itself.
     */
    public DeploymentConfiguration withCloudServiceConfiguration(CloudServiceConfiguration cloudServiceConfiguration) {
        this.cloudServiceConfiguration = cloudServiceConfiguration;
        return this;
    }

    /**
     * Get the virtualMachineConfiguration property: The configuration for compute nodes in a pool based on the Azure
     * Virtual Machines infrastructure.
     * 
     * This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
     * 
     * @return the virtualMachineConfiguration value.
     */
    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    /**
     * Set the virtualMachineConfiguration property: The configuration for compute nodes in a pool based on the Azure
     * Virtual Machines infrastructure.
     * 
     * This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
     * 
     * @param virtualMachineConfiguration the virtualMachineConfiguration value to set.
     * @return the DeploymentConfiguration object itself.
     */
    public DeploymentConfiguration
        withVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (cloudServiceConfiguration() != null) {
            cloudServiceConfiguration().validate();
        }
        if (virtualMachineConfiguration() != null) {
            virtualMachineConfiguration().validate();
        }
    }
}
