// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.batch.fluent.models.DetectorResponseInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Values returned by the List operation.
 */
@Fluent
public final class DetectorListResult {
    /*
     * The collection of Batch account detectors returned by the listing operation.
     */
    @JsonProperty(value = "value")
    private List<DetectorResponseInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of DetectorListResult class.
     */
    public DetectorListResult() {
    }

    /**
     * Get the value property: The collection of Batch account detectors returned by the listing operation.
     * 
     * @return the value value.
     */
    public List<DetectorResponseInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of Batch account detectors returned by the listing operation.
     * 
     * @param value the value value to set.
     * @return the DetectorListResult object itself.
     */
    public DetectorListResult withValue(List<DetectorResponseInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DetectorListResult object itself.
     */
    public DetectorListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
